package at.petrak.hexcasting.mixin;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.common.loot.HexLootHandler;
import at.petrak.hexcasting.mixin.accessor.AccessorLootTable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import var;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_131;
import net.minecraft.class_2246;
import net.minecraft.class_5350;

@Mixin(class_5350.class)
public class MixinReloadableServerResources {
    @Inject(method = "loadResources", at = @At("RETURN"), cancellable = true)
    private static void onLoadResources(CallbackInfoReturnable<CompletableFuture<class_5350>> cir) {
        cir.setReturnValue(cir.getReturnValue().thenApply((rsr) -> {
            var amethystTable = rsr.method_29469().method_367(class_2246.field_27161.method_26162());
            var theCoolerAmethystTable = (AccessorLootTable) amethystTable;
            var oldFuncs = theCoolerAmethystTable.hex$getFunctions();
            var newFuncs = Arrays.copyOf(oldFuncs, oldFuncs.length + 1);
            var shardReducer = rsr.method_32703().method_32404(HexLootHandler.FUNC_AMETHYST_SHARD_REDUCER);
            if (shardReducer != null) {
                newFuncs[newFuncs.length - 1] = shardReducer;
                theCoolerAmethystTable.hex$setFunctions(newFuncs);
                theCoolerAmethystTable.hex$setCompositeFunction(class_131.method_594(newFuncs));
            } else {
                HexAPI.LOGGER.warn("{} was not found?", HexLootHandler.FUNC_AMETHYST_SHARD_REDUCER);
            }
            return rsr;
        }));
    }
}
