package at.petrak.hexcasting.mixin;

import at.petrak.hexcasting.common.misc.Brainsweeping;
import net.minecraft.class_3763;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import var;

// Prevents the witch from joining a raid
@Mixin(class_3763.class)
public class MixinRaider {
    @Redirect(method = "aiStep", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/raid/Raider;isAlive()Z"))
    private boolean isAliveForAiPurposes(class_3763 instance) {
        var self = (class_3763) (Object) this;
        return self.isAlive() && !Brainsweeping.isBrainswept(self);
    }
}
