package at.petrak.hexcasting.mixin;

import at.petrak.hexcasting.common.misc.Brainsweeping;
import net.minecraft.class_1308;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import var;

// Prevents brainswept mobs from having an AI tick
@Mixin(class_1308.class)
public class MixinMob {
    @Inject(method = "serverAiStep", at = @At("HEAD"), cancellable = true)
    private void onRegisterBrainGoals(CallbackInfo ci) {
        var self = (class_1308) (Object) this;
        if (Brainsweeping.isBrainswept(self)) {
            ci.cancel();
        }
    }

    @Inject(method = "playAmbientSound", at = @At("HEAD"), cancellable = true)
    protected void onPlayAmbientSound(CallbackInfo ci) {
        var self = (class_1308) (Object) this;
        if (Brainsweeping.isBrainswept(self)) {
            ci.cancel();
        }
    }
}
