package at.petrak.hexcasting.mixin;

import at.petrak.hexcasting.common.misc.Brainsweeping;
import net.minecraft.class_1646;
import net.minecraft.class_1916;
import net.minecraft.class_3988;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import var;

// Prevents the villager from having any offers if it's brainswept
@Mixin(class_3988.class)
public class MixinAbstractVillager {
    @Inject(method = "getOffers", at = @At("HEAD"), cancellable = true)
    private void nixOffers(CallbackInfoReturnable<class_1916> cir) {
        var self = (class_1646) (Object) this;
        if (Brainsweeping.isBrainswept(self)) {
            cir.setReturnValue(new class_1916());
        }
    }
}
