package at.petrak.hexcasting.interop.patchouli;

import vazkii.patchouli.api.IVariable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3956;
import var;

/**
 * > no this is a "literally copy these files/parts of file into your mod"
 * > we should put this in patchy but lol
 * > lazy
 * -- Hubry Vazcord
 */
public class PatchouliUtils {
    @SuppressWarnings("unchecked")
    public static <T extends class_1860<C>, C extends class_1263> T getRecipe(class_3956<T> type, class_2960 id) {
        // PageDoubleRecipeRegistry
        if (class_310.method_1551().field_1687 == null) {
            return null;
        } else {
            var manager = class_310.method_1551().field_1687.method_8433();
            return (T) manager.byKey(id)
                .filter((recipe) -> recipe.getType() == type).orElse(null);
        }
    }

    /**
     * Combines the ingredients, returning the first matching stack of each, then the second stack of each, etc.
     * looping back ingredients that run out of matched stacks, until the ingredients reach the length
     * of the longest ingredient in the recipe set.
     *
     * @param ingredients           List of ingredients in the specific slot
     * @param longestIngredientSize Longest ingredient in the entire recipe
     * @return Serialized Patchouli ingredient string
     */
    public static IVariable interweaveIngredients(List<class_1856> ingredients, int longestIngredientSize) {
        if (ingredients.size() == 1) {
            return IVariable.wrapList(Arrays.stream(ingredients.get(0).method_8105()).map(IVariable::from).collect(
                Collectors.toList()));
        }

        class_1799[] empty = {class_1799.field_8037};
        List<class_1799[]> stacks = new ArrayList<>();
        for (class_1856 ingredient : ingredients) {
            if (ingredient != null && !ingredient.method_8103()) {
                stacks.add(ingredient.method_8105());
            } else {
                stacks.add(empty);
            }
        }
        List<IVariable> list = new ArrayList<>(stacks.size() * longestIngredientSize);
        for (int i = 0; i < longestIngredientSize; i++) {
            for (class_1799[] stack : stacks) {
                list.add(IVariable.from(stack[i % stack.length]));
            }
        }
        return IVariable.wrapList(list);
    }

    /**
     * Overload of the method above that uses the provided list's longest ingredient size.
     */
    public static IVariable interweaveIngredients(List<class_1856> ingredients) {
        return interweaveIngredients(ingredients,
            ingredients.stream().mapToInt(ingr -> ingr.method_8105().length).max().orElse(1));
    }
}
