/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package at.petrak.hexcasting.interop.patchouli;

import at.petrak.hexcasting.api.HexAPI;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1856;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3955;
import net.minecraft.class_3956;

public class MultiCraftingProcessor implements IComponentProcessor {
    private List<class_3955> recipes;
    private boolean shapeless = true;
    private int longestIngredientSize = 0;
    private boolean hasCustomHeading;

    @Override
    public void setup(IVariableProvider variables) {
        List<String> names = variables.get("recipes").asStream().map(IVariable::asString).collect(Collectors.toList());
        this.recipes = new ArrayList<>();
        for (String name : names) {
            class_3955 recipe = PatchouliUtils.getRecipe(class_3956.field_17545, new class_2960(name));
            if (recipe != null) {
                recipes.add(recipe);
                if (shapeless) {
                    shapeless = !(recipe instanceof class_1869);
                }
                for (class_1856 ingredient : recipe.method_8117()) {
                    int size = ingredient.method_8105().length;
                    if (longestIngredientSize < size) {
                        longestIngredientSize = size;
                    }
                }
            } else {
                HexAPI.LOGGER.warn("Missing crafting recipe " + name);
            }
        }
        this.hasCustomHeading = variables.has("heading");
    }

    @Override
    public IVariable process(String key) {
        if (recipes.isEmpty()) {
            return null;
        }
        if (key.equals("heading")) {
            if (!hasCustomHeading) {
                return IVariable.from(recipes.get(0).method_8110().method_7964());
            }
            return null;
        }
        if (key.startsWith("input")) {
            int index = Integer.parseInt(key.substring(5)) - 1;
            int shapedX = index % 3;
            int shapedY = index / 3;
            List<class_1856> ingredients = new ArrayList<>();
            for (class_3955 recipe : recipes) {
                if (recipe instanceof class_1869 shaped) {
                    if (shaped.method_8150() < shapedX + 1) {
                        ingredients.add(class_1856.field_9017);
                    } else {
                        int realIndex = index - (shapedY * (3 - shaped.method_8150()));
                        class_2371<class_1856> list = recipe.method_8117();
                        ingredients.add(list.size() > realIndex ? list.get(realIndex) : class_1856.field_9017);
                    }

                } else {
                    class_2371<class_1856> list = recipe.method_8117();
                    ingredients.add(list.size() > index ? list.get(index) : class_1856.field_9017);
                }
            }
            return PatchouliUtils.interweaveIngredients(ingredients, longestIngredientSize);
        }
        if (key.equals("output")) {
            return IVariable.wrapList(
                recipes.stream().map(class_3955::method_8110).map(IVariable::from).collect(Collectors.toList()));
        }
        if (key.equals("shapeless")) {
            return IVariable.wrap(shapeless);
        }
        return null;
    }
}
