package at.petrak.hexcasting.interop.patchouli;

import at.petrak.hexcasting.common.recipe.BrainsweepRecipe;
import at.petrak.hexcasting.common.recipe.HexRecipeSerializers;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import var;

public class BrainsweepProcessor implements IComponentProcessor {
    private BrainsweepRecipe recipe;

    @Override
    public void setup(IVariableProvider vars) {
        var id = new class_2960(vars.get("recipe").asString());

        var recman = class_310.method_1551().field_1687.method_8433();
        var brainsweepings = recman.getAllRecipesFor(HexRecipeSerializers.BRAINSWEEP_TYPE);
        for (var poisonApples : brainsweepings) {
            if (poisonApples.getId().equals(id)) {
                this.recipe = poisonApples;
                break;
            }
        }
    }

    @Override
    public IVariable process(String key) {
        if (this.recipe == null) {
            return null;
        }

        switch (key) {
            case "header" -> {
                return IVariable.from(this.recipe.result().method_26204().method_9518());
            }
            case "input" -> {
                var inputStacks = this.recipe.blockIn().getDisplayedStacks();
                return IVariable.from(inputStacks.toArray(new class_1799[0]));
            }
            case "result" -> {
                return IVariable.from(new class_1799(this.recipe.result().method_26204()));
            }

            case "entity" -> {
                var profession = Objects.requireNonNullElse(this.recipe.villagerIn().profession(),
                    new class_2960("toolsmith"));
                var biome = Objects.requireNonNullElse(this.recipe.villagerIn().biome(),
                    new class_2960("plains"));
                var level = this.recipe.villagerIn().minLevel();
                var iHatePatchouli = String.format(
                    "minecraft:villager{VillagerData:{profession:'%s',type:'%s',level:%d}}",
                    profession, biome, level);
                return IVariable.wrap(iHatePatchouli);
            }
            case "profession" -> {
                var profession = this.recipe.villagerIn().profession();
                if (profession == null) {
                    return IVariable.wrap(class_1074.method_4662("hexcasting.tooltip.brainsweep.profession.any"));
                }
                // Villager.java:677
                // jesus christ the things i do for this mod
                var probablyTheKeyForTheName = "entity.minecraft.villager." + profession.getPath();
                var out = class_1074.method_4662("hexcasting.tooltip.brainsweep.profession", class_1074.method_4662(probablyTheKeyForTheName));
                return IVariable.wrap(out);
            }
            case "biome" -> {
                var biome = this.recipe.villagerIn().biome();
                if (biome == null) {
                    return IVariable.wrap(class_1074.method_4662("hexcasting.tooltip.brainsweep.biome.any"));
                }
                // i fucking give up
                var definitelyProbablyTheKeyWhyDidIMakeThisUpdateSoBig = "biome.minecraft." + biome.getPath();
                var out = class_1074.method_4662("hexcasting.tooltip.brainsweep.biome",
                    class_1074.method_4662(definitelyProbablyTheKeyWhyDidIMakeThisUpdateSoBig));
                return IVariable.wrap(out);
            }
            case "minLevel" -> {
                var minLevel = this.recipe.villagerIn().minLevel();
                if (minLevel >= 5)
                    return IVariable.wrap(class_1074.method_4662("hexcasting.tooltip.brainsweep.level",
                            class_1074.method_4662("merchant.level." + minLevel)));
                else if (minLevel <= 1)
                    return IVariable.wrap(class_1074.method_4662("hexcasting.tooltip.brainsweep.level.any"));
                else
                    return IVariable.wrap(class_1074.method_4662("hexcasting.tooltip.brainsweep.min_level",
                            class_1074.method_4662("merchant.level." + minLevel)));
            }
            default -> {
                return null;
            }
        }
    }
}
