package at.petrak.hexcasting.fabric.xplat;

import at.petrak.hexcasting.common.network.IMessage;
import at.petrak.hexcasting.fabric.client.ExtendedTexture;
import at.petrak.hexcasting.xplat.IClientXplatAbstractions;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.minecraft.class_1044;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1800;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2960;
import net.minecraft.class_4002;
import net.minecraft.class_5272;
import net.minecraft.class_5617;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_638;
import net.minecraft.class_707;
import org.jetbrains.annotations.Nullable;
import record;
import java.util.function.Function;

public class FabricClientXplatImpl implements IClientXplatAbstractions {
    @Override
    public void sendPacketToServer(IMessage packet) {
        ClientPlayNetworking.send(packet.getFabricId(), packet.toBuf());
    }

    @Override
    public void setRenderLayer(class_2248 block, class_1921 type) {
        BlockRenderLayerMap.INSTANCE.putBlock(block, type);
    }

    @Override
    public <T extends class_1297> void registerEntityRenderer(class_1299<? extends T> type,
        class_5617<T> renderer) {
        EntityRendererRegistry.register(type, renderer);
    }

    @Override
    public <T extends class_2394> void registerParticleType(class_2396<T> type,
        Function<class_4002, class_707<T>> factory) {
        ParticleFactoryRegistry.getInstance().register(type, factory::apply);
    }

    @Override
    public <T extends class_5684 & class_5632> void registerIdentityTooltipMapping(Class<T> clazz) {
        TooltipComponentCallback.EVENT.register(data -> {
            if (clazz.isAssignableFrom(data.getClass())) {
                return clazz.cast(data);
            }
            return null;
        });
    }

    // suck it fabric trying to be "safe"
    private record UnclampedClampedItemPropFunc(class_1800 inner) implements ClampedItemPropertyFunction {
        @Override
        public float unclampedCall(class_1799 stack, @Nullable class_638 level, @Nullable class_1309 entity,
            int seed) {
            return inner.call(stack, level, entity, seed);
        }

        @Override
        public float call(class_1799 stack, @Nullable class_638 level, @Nullable class_1309 entity, int seed) {
            return this.unclampedCall(stack, level, entity, seed);
        }
    }

    @Override
    public void registerItemProperty(class_1792 item, class_2960 id, class_1800 func) {
        class_5272.method_27879(item, id, new UnclampedClampedItemPropFunc(func));
    }

    @Override
    public void setFilterSave(class_1044 texture, boolean filter, boolean mipmap) {
        ((ExtendedTexture) texture).setFilterSave(filter, mipmap);
    }

    @Override
    public void restoreLastFilter(class_1044 texture) {
        ((ExtendedTexture) texture).restoreLastFilter();
    }
}
