package at.petrak.hexcasting.fabric.recipe;

import at.petrak.hexcasting.api.addldata.DataHolder;
import at.petrak.hexcasting.api.item.DataHolderItem;
import at.petrak.hexcasting.api.spell.DatumType;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.Widget;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.jetbrains.annotations.NotNull;

import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1869;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import java.util.Arrays;
import java.util.Objects;

import static at.petrak.hexcasting.api.HexAPI.modLoc;

public class FabricUnsealedIngredient extends class_1856 {
	private static final class_2960 ID = modLoc("unsealed");

	private final class_1799 stack;

	protected FabricUnsealedIngredient(class_1799 stack) {
		super(Arrays.stream(DatumType.values())
			.filter((it) -> it != DatumType.EMPTY && it != DatumType.OTHER)
			.map((type) -> {
				class_1799 newStack = stack.method_7972();
				NBTHelper.putString(newStack, DataHolderItem.TAG_OVERRIDE_VISUALLY, SpellDatum.tagForType(type));
				return new class_1856.class_1857(newStack);
			}));
		this.stack = stack;
	}

	/**
	 * Creates a new ingredient matching the given stack
	 */
	public static FabricUnsealedIngredient of(class_1799 stack) {
		return new FabricUnsealedIngredient(stack);
	}

	@Override
	public boolean method_8093(@Nullable class_1799 input) {
		if (input == null)
			return false;
		if(this.stack.method_7909() == input.method_7909() && this.stack.method_7919() == input.method_7919()) {
			DataHolder holder = IXplatAbstractions.INSTANCE.findDataHolder(this.stack);
			if (holder != null) {
				return holder.readRawDatum() != null && holder.writeDatum(SpellDatum.make(Widget.NULL), true);
			}
		}

		return false;
	}

	@Override
	public @NotNull JsonElement method_8089() {
		JsonObject json = new JsonObject();
		json.addProperty("type", Objects.toString(ID));
		json.addProperty("item", Objects.toString(class_2378.field_11142.method_10221(this.stack.method_7909())));
		return json;
	}

	public static class_1856 method_8086(class_2540 friendlyByteBuf) {
		friendlyByteBuf.markReaderIndex();
		try {
			if (friendlyByteBuf.method_10810().equals(ID)) {
				return new FabricUnsealedIngredient(friendlyByteBuf.method_10819());
			}
		} catch (Exception e) {
			// There clearly wasn't a resource location there. This is kind of a hack but ehh
			friendlyByteBuf.resetReaderIndex();
		}

		return null;
	}

	public static class_1856 method_8102(JsonElement element) {
		if (element == null || element.isJsonNull() || !element.isJsonObject())
			return null;

		JsonObject object = element.getAsJsonObject();

		if (object.has("type") && object.getAsJsonPrimitive("type").getAsString().equals(ID.toString())) {
			return new FabricUnsealedIngredient(new class_1799(class_1869.method_8155(object)));
		}

		return null;
	}

	@Override
	public void method_8088(class_2540 friendlyByteBuf) {
		friendlyByteBuf.method_10812(ID);
		friendlyByteBuf.method_10793(stack);
	}
}
