package at.petrak.hexcasting.fabric.mixin;

import at.petrak.hexcasting.common.blocks.behavior.HexStrippables;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import var;
import java.util.Optional;
import net.minecraft.class_1743;
import net.minecraft.class_2680;

// https://github.com/VazkiiMods/Botania/blob/1.18.x/Fabric/src/main/java/vazkii/botania/fabric/mixin/FabricMixinAxeItem.java
@Mixin(class_1743.class)
public class FabricAxeItemMixin {
    @Inject(method = "getStripped", at = @At("RETURN"), cancellable = true)
    private void stripBlock(class_2680 state, CallbackInfoReturnable<Optional<class_2680>> cir) {
        if (cir.getReturnValue().isEmpty()) {
            var block = HexStrippables.STRIPPABLES.get(state.method_26204());
            if (block != null) {
                cir.setReturnValue(Optional.of(block.withPropertiesOf(state)));
            }
        }
    }
}
