package at.petrak.hexcasting.fabric.interop.rei;

import at.petrak.hexcasting.client.ClientTickCounter;
import at.petrak.hexcasting.common.recipe.ingredient.VillagerIngredient;
import com.mojang.blaze3d.systems.RenderSystem;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1646;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_898;
import org.jetbrains.annotations.NotNull;
import var;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VillagerWidget extends Widget {
	protected final VillagerIngredient villager;
	private final int x;
	private final int y;

	private class_1646 displayVillager;

	public VillagerWidget(VillagerIngredient villager, int x, int y) {
		this.villager = villager;
		this.x = x;
		this.y = y;
	}

	@Override
	public void method_25394(@NotNull class_4587 poseStack, int mouseX, int mouseY, float delta) {
		class_638 level = class_310.method_1551().field_1687;
		if (level != null) {
			class_3852 profession = class_2378.field_17167.method_17966(villager.profession())
					.orElse(class_3852.field_17064);
			class_3854 biome = class_2378.field_17166.method_17966(villager.biome())
					.orElse(class_3854.field_17073);
			int minLevel = villager.minLevel();
			if (displayVillager == null) {
				displayVillager = new class_1646(class_1299.field_6077, level);
			}

			displayVillager.method_7195(displayVillager.method_7231()
					.method_16921(profession)
					.method_16922(biome)
					.method_16920(minLevel));

			RenderSystem.enableBlend();
			RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
			renderEntity(poseStack, displayVillager, level, 50 + x, 62.5f + y, ClientTickCounter.total, 20, 0);
		}

		if (method_25405(mouseX, mouseY))
			getTooltip(new Point(mouseX, mouseY)).queue();
	}

	@Override
	public boolean containsMouse(double mouseX, double mouseY) {
		double mX = mouseX - x;
		double mY = mouseY - y;
		return 37 <= mX && mX <= 37 + 26 && 19 <= mY && mY <= 19 + 48;
	}

	@NotNull
	@Override
	public Tooltip getTooltip(Point mouse) {
		List<class_2561> tooltip = new ArrayList<>(3);
		var profession = villager.profession();
		if (profession == null) {
			tooltip.add(new class_2588("hexcasting.tooltip.brainsweep.profession.any"));
		} else {
			var professionKey = "entity.minecraft.villager." + profession.getPath();
			tooltip.add(new class_2588("hexcasting.tooltip.brainsweep.profession",
					new class_2588(professionKey)));
		}
		var biome = villager.biome();
		if (biome == null) {
			tooltip.add(new class_2588("hexcasting.tooltip.brainsweep.biome.any"));
		} else {
			var biomeKey = "biome.minecraft." + biome.getPath();
			tooltip.add(new class_2588("hexcasting.tooltip.brainsweep.biome",
					new class_2588(biomeKey)));
		}

		var minLevel = villager.minLevel();
		if (minLevel >= 5)
			tooltip.add(new class_2588("hexcasting.tooltip.brainsweep.level",
					new class_2588("merchant.level." + minLevel)));
		else if (minLevel <= 1)
			tooltip.add(new class_2588("hexcasting.tooltip.brainsweep.level.any"));
		else
			tooltip.add(new class_2588("hexcasting.tooltip.brainsweep.min_level",
					new class_2588("merchant.level." + minLevel)));

		return Tooltip.create(mouse, tooltip);
	}

	@Override
	public List<? extends class_364> method_25396() {
		return Collections.emptyList();
	}

	private static void renderEntity(class_4587 ms, class_1297 entity, class_1937 world, float x, float y, float rotation,
									 float renderScale, float offset) {
		entity.field_6002 = world;
		ms.method_22903();
		ms.method_22904(x, y, 50.0D);
		ms.method_22905(renderScale, renderScale, renderScale);
		ms.method_22904(0.0D, offset, 0.0D);
		ms.method_22907(class_1160.field_20707.method_23214(180.0F));
		ms.method_22907(class_1160.field_20705.method_23214(rotation));
		class_898 erd = class_310.method_1551().method_1561();
		class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
		erd.method_3948(false);
		erd.method_3954(entity, 0.0D, 0.0D, 0.0D, 0.0F, 1.0F, ms, immediate, 15728880);
		erd.method_3948(true);
		immediate.method_22993();
		ms.method_22909();
	}
}
