package at.petrak.hexcasting.fabric.interop.rei;

import com.mojang.blaze3d.systems.RenderSystem;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;
import var;
import java.util.ArrayList;
import java.util.List;

import static at.petrak.hexcasting.api.HexAPI.modLoc;

public class BrainsweepRecipeCategory implements DisplayCategory<BrainsweepRecipeDisplay> {
    private final class_2960 OVERLAY = modLoc("textures/gui/brainsweep_jei.png");

    private final Renderer icon;
    private final class_2561 localizedName;

    public BrainsweepRecipeCategory() {
        var brainsweep = modLoc("brainsweep");
        localizedName = new class_2588("hexcasting.spell." + brainsweep);
        icon = new PatternRendererREI(brainsweep, 16, 16);
    }

    @Override
    public Renderer getIcon() {
        return icon;
    }

    @Override
    public @NotNull class_2561 getTitle() {
        return localizedName;
    }

    @Override
    public List<Widget> setupDisplay(BrainsweepRecipeDisplay display, Rectangle bounds) {
        List<Widget> widgets = new ArrayList<>();
        widgets.add(Widgets.createRecipeBase(bounds));
        widgets.add(Widgets.createDrawableWidget(((helper, matrices, mouseX, mouseY, delta) -> {
            RenderSystem.enableBlend();
            RenderSystem.setShaderTexture(0, OVERLAY);
            class_332.method_25290(matrices, bounds.getMinX() + 7, bounds.getMinY() + 7, 7, 7, 104, 71, 128, 128);
            RenderSystem.disableBlend();
        })));
        widgets.add(new VillagerWidget(display.recipe.villagerIn(), bounds.getMinX(), bounds.getMinY()));
        widgets.add(Widgets.createSlot(new Point(bounds.getMinX() + 12, bounds.getMinY() + 35)).entries(display.getInputEntries().get(0)).disableBackground());
        widgets.add(Widgets.createSlot(new Point(bounds.getMinX() + 87, bounds.getMinY() + 35)).entries(display.getOutputEntries().get(0)).disableBackground());

        return widgets;
    }

    @Override
    public CategoryIdentifier<? extends BrainsweepRecipeDisplay> getCategoryIdentifier() {
        return HexREIPlugin.BRAINSWEEP;
    }

    @Override
    public int getDisplayHeight() {
        return 85;
    }

    @Override
    public int getDisplayWidth(BrainsweepRecipeDisplay display) {
        return 118;
    }
}
