package at.petrak.hexcasting.fabric.datagen;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.datagen.HexBlockTagProvider;
import at.petrak.hexcasting.datagen.HexItemTagProvider;
import at.petrak.hexcasting.datagen.HexLootTables;
import at.petrak.hexcasting.datagen.IXplatIngredients;
import at.petrak.hexcasting.datagen.recipe.HexplatRecipes;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.world.item.*;
import var;
import java.util.EnumMap;
import java.util.stream.Stream;

public class HexFabricDataGenerators implements DataGeneratorEntrypoint {
    @Override
    public void onInitializeDataGenerator(FabricDataGenerator gen) {
        HexAPI.LOGGER.info("Starting Fabric-specific datagen");

        gen.method_10314(new HexplatRecipes(gen, INGREDIENTS));

        var xtags = IXplatAbstractions.INSTANCE.tags();
        var blockTagProvider = new HexBlockTagProvider(gen, xtags);
        gen.method_10314(blockTagProvider);
        gen.method_10314(new HexItemTagProvider(gen, blockTagProvider, xtags));

        gen.method_10314(new HexLootTables(gen));
    }

    private static final IXplatIngredients INGREDIENTS = new IXplatIngredients() {
        @Override
        public class_1856 glowstoneDust() {
            return new class_1856(Stream.of(
                new class_1856.class_1857(new class_1799(class_1802.field_8601)),
                new class_1856.class_1858(tag("glowstone_dusts"))
            ));
        }

        @Override
        public class_1856 leather() {
            // apparently c:leather also includes rabbit hide
            return class_1856.method_8091(class_1802.field_8745);
        }

        @Override
        public class_1856 ironNugget() {
            return new class_1856(Stream.of(
                new class_1856.class_1857(new class_1799(class_1802.field_8675)),
                new class_1856.class_1858(tag("iron_nuggets"))
            ));
        }

        @Override
        public class_1856 goldNugget() {
            return new class_1856(Stream.of(
                new class_1856.class_1857(new class_1799(class_1802.field_8397)),
                new class_1856.class_1858(tag("gold_nuggets"))
            ));
        }

        @Override
        public class_1856 copperIngot() {
            return new class_1856(Stream.of(
                new class_1856.class_1857(new class_1799(class_1802.field_27022)),
                new class_1856.class_1858(tag("copper_ingots"))
            ));
        }

        @Override
        public class_1856 ironIngot() {
            return new class_1856(Stream.of(
                new class_1856.class_1857(new class_1799(class_1802.field_8620)),
                new class_1856.class_1858(tag("iron_ingots"))
            ));
        }

        @Override
        public class_1856 goldIngot() {
            return new class_1856(Stream.of(
                new class_1856.class_1857(new class_1799(class_1802.field_8695)),
                new class_1856.class_1858(tag("gold_ingots"))
            ));
        }

        @Override
        public EnumMap<class_1767, class_1856> dyes() {
            var out = new EnumMap<class_1767, class_1856>(class_1767.class);
            for (var col : class_1767.values()) {
                out.put(col, new class_1856(Stream.of(
                    new class_1856.class_1857(new class_1799(class_1769.method_7803(col))),
                    new class_1856.class_1858(
                        class_6862.method_40092(class_2378.field_25108,
                            new class_2960("c", col.getSerializedName() + "_dye"))),
                    new class_1856.class_1858(
                        class_6862.method_40092(class_2378.field_25108,
                            new class_2960("c", col.getSerializedName() + "_dyes"))
                    ))));
            }
            return out;
        }

        @Override
        public class_1856 stick() {
            return new class_1856(Stream.of(
                new class_1856.class_1857(new class_1799(class_1802.field_8600)),
                new class_1856.class_1858(tag("wood_sticks"))
            ));
        }
    };

    private static class_6862<class_1792> tag(String s) {
        return tag("c", s);
    }

    private static class_6862<class_1792> tag(String namespace, String s) {
        return class_6862.method_40092(class_2378.field_25108, new class_2960(namespace, s));
    }
}
