package at.petrak.hexcasting.fabric.cc;

import at.petrak.hexcasting.api.player.Sentinel;
import at.petrak.hexcasting.api.utils.HexUtils;
import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import net.minecraft.class_1657;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import var;

public class CCSentinel implements Component, AutoSyncedComponent {
    public static final String
        TAG_HAS_SENTINEL = "has_sentinel",
        TAG_EXTENDS_RANGE = "extends_range",
        TAG_POSITION = "position",
        TAG_DIMENSION = "dimension";

    private final class_1657 owner;
    private Sentinel sentinel = Sentinel.none();

    public CCSentinel(class_1657 owner) {
        this.owner = owner;
    }

    public Sentinel getSentinel() {
        return sentinel;
    }

    public void setSentinel(Sentinel sentinel) {
        this.sentinel = sentinel;
        HexCardinalComponents.SENTINEL.sync(this.owner);
    }

    @Override
    public void readFromNbt(class_2487 tag) {
        var hasSentinel = tag.method_10577(TAG_HAS_SENTINEL);
        if (hasSentinel) {
            var extendsRange = tag.method_10577(TAG_EXTENDS_RANGE);
            var position = HexUtils.vecFromNBT(tag.method_10565(TAG_POSITION));
            var dim = class_5321.method_29179(class_2378.field_25298,
                new class_2960(tag.method_10558(TAG_DIMENSION)));
            this.sentinel = new Sentinel(true, extendsRange, position, dim);
        } else {
            this.sentinel = Sentinel.none();
        }
    }

    @Override
    public void writeToNbt(class_2487 tag) {
        tag.method_10556(TAG_HAS_SENTINEL, this.sentinel.hasSentinel());
        if (this.sentinel.hasSentinel()) {
            tag.method_10556(TAG_EXTENDS_RANGE, this.sentinel.extendsRange());
            tag.method_10566(TAG_POSITION, HexUtils.serializeToNBT(this.sentinel.position()));
            tag.method_10582(TAG_DIMENSION, this.sentinel.dimension().method_29177().toString());
        }
    }
}
