package at.petrak.hexcasting.fabric.cc;

import at.petrak.hexcasting.api.spell.casting.ResolvedPattern;
import dev.onyxstudios.cca.api.v3.component.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import var;

public class CCPatterns implements Component {
    public static final String TAG_PATTERNS = "patterns";

    private final class_1657 owner;

    private List<ResolvedPattern> patterns = Collections.emptyList();

    public CCPatterns(class_3222 owner) {
        this.owner = owner;
    }


    public List<ResolvedPattern> getPatterns() {
        return patterns;
    }

    public void setPatterns(List<ResolvedPattern> patterns) {
        this.patterns = patterns;
    }

    @Override
    public void readFromNbt(class_2487 tag) {
        class_2499 patternsTag = tag.method_10554(TAG_PATTERNS, class_2520.field_33260);

        List<ResolvedPattern> patterns = new ArrayList<>(patternsTag.size());

        for (int i = 0; i < patternsTag.size(); i++) {
            patterns.add(ResolvedPattern.fromNBT(patternsTag.method_10602(i)));
        }
        this.patterns = patterns;
    }

    @Override
    public void writeToNbt(class_2487 tag) {
        var listTag = new class_2499();
        for (ResolvedPattern pattern : patterns) {
            listTag.add(pattern.serializeToNBT());
        }
        tag.method_10566(TAG_PATTERNS, listTag);
    }
}
