package at.petrak.hexcasting.fabric.cc;

import at.petrak.hexcasting.api.addldata.ManaHolder;
import at.petrak.hexcasting.api.item.ManaHolderItem;
import dev.onyxstudios.cca.api.v3.item.ItemComponent;
import java.util.function.Supplier;
import net.minecraft.class_1799;

public abstract class CCManaHolder extends ItemComponent implements ManaHolder {
    public CCManaHolder(class_1799 stack) {
        super(stack, HexCardinalComponents.MANA_HOLDER);
    }

    public static class ItemBased extends CCManaHolder {
        private final ManaHolderItem manaHolder;

        public ItemBased(class_1799 stack) {
            super(stack);
            if (!(stack.method_7909() instanceof ManaHolderItem mana)) {
                throw new IllegalStateException("item is not a mana holder: " + stack);
            }
            this.manaHolder = mana;
        }

        @Override
        public int getMana() {
            return this.manaHolder.getMana(this.stack);
        }

        @Override
        public int getMaxMana() {
            return this.manaHolder.getMaxMana(this.stack);
        }

        @Override
        public void setMana(int mana) {
            this.manaHolder.setMana(this.stack, mana);
        }

        @Override
        public boolean canRecharge() {
            return this.manaHolder.canRecharge(this.stack);
        }

        @Override
        public boolean canProvide() {
            return this.manaHolder.manaProvider(this.stack);
        }

        @Override
        public int getConsumptionPriority() {
            return 40;
        }

        @Override
        public boolean canConstructBattery() {
            return false;
        }
    }

    public static class Static extends CCManaHolder {
        private final Supplier<Integer> baseWorth;
        private final int consumptionPriority;

        public Static(Supplier<Integer> baseWorth, int consumptionPriority, class_1799 stack) {
            super(stack);
            this.baseWorth = baseWorth;
            this.consumptionPriority = consumptionPriority;
        }
        
        @Override
        public int getMana() {
            return baseWorth.get() * stack.method_7947();
        }

        @Override
        public int getMaxMana() {
            return getMana();
        }

        @Override
        public void setMana(int mana) {
            // NO-OP
        }

        @Override
        public boolean canRecharge() {
            return false;
        }

        @Override
        public boolean canProvide() {
            return true;
        }

        @Override
        public int getConsumptionPriority() {
            return consumptionPriority;
        }

        @Override
        public boolean canConstructBattery() {
            return true;
        }

        @Override
        public int withdrawMana(int cost, boolean simulate) {
            int worth = baseWorth.get();
            if (cost < 0) {
                cost = worth * stack.method_7947();
            }
            double itemsRequired = cost / (double) worth;
            int itemsUsed = Math.min((int) Math.ceil(itemsRequired), stack.method_7947());
            if (!simulate) {
                stack.method_7934(itemsUsed);
            }
            return itemsUsed * worth;
        }
    }
}
