package at.petrak.hexcasting.fabric.cc;

import at.petrak.hexcasting.api.addldata.HexHolder;
import at.petrak.hexcasting.api.item.HexHolderItem;
import at.petrak.hexcasting.api.spell.SpellDatum;
import dev.onyxstudios.cca.api.v3.item.ItemComponent;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_3218;

public abstract class CCHexHolder extends ItemComponent implements HexHolder {
    public CCHexHolder(class_1799 stack) {
        super(stack, HexCardinalComponents.HEX_HOLDER);
    }

    public static class ItemBased extends CCHexHolder {
        private final HexHolderItem hexHolder;

        public ItemBased(class_1799 owner) {
            super(owner);
            var item = owner.method_7909();
            if (!(item instanceof HexHolderItem hexHolderItem)) {
                throw new IllegalStateException("item is not a colorizer: " + owner);
            }
            this.hexHolder = hexHolderItem;
        }


        @Override
        public boolean canDrawManaFromInventory() {
            return this.hexHolder.canDrawManaFromInventory(this.stack);
        }

        @Override
        public boolean hasHex() {
            return this.hexHolder.hasHex(this.stack);
        }

        @Override
        public @Nullable List<SpellDatum<?>> getHex(class_3218 level) {
            return this.hexHolder.getHex(this.stack, level);
        }

        @Override
        public void writeHex(List<SpellDatum<?>> patterns, int mana) {
            this.hexHolder.writeHex(this.stack, patterns, mana);
        }

        @Override
        public void clearHex() {
            this.hexHolder.clearHex(this.stack);
        }
    }
}
