package at.petrak.hexcasting.fabric.cc;

import at.petrak.hexcasting.api.player.FlightAbility;
import at.petrak.hexcasting.api.utils.HexUtils;
import dev.onyxstudios.cca.api.v3.component.Component;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import var;

public class CCFlight implements Component {
    public static final String
        TAG_ALLOWED = "allowed",
        TAG_TIME_LEFT = "time_left",
        TAG_DIMENSION = "dimension",
        TAG_ORIGIN = "origin",
        TAG_RADIUS = "radius";

    private final class_3222 owner;
    private FlightAbility flight = FlightAbility.deny();

    public CCFlight(class_3222 owner) {
        this.owner = owner;
    }


    public FlightAbility getFlight() {
        return flight;
    }

    public void setFlight(FlightAbility flight) {
        this.flight = flight;
    }

    @Override
    public void readFromNbt(class_2487 tag) {
        var allowed = tag.method_10577(TAG_ALLOWED);
        if (!allowed) {
            this.flight = FlightAbility.deny();
        } else {
            var timeLeft = tag.method_10550(TAG_TIME_LEFT);
            var dim = class_5321.method_29179(class_2378.field_25298,
                new class_2960(tag.method_10558(TAG_DIMENSION)));
            var origin = HexUtils.vecFromNBT(tag.method_10565(TAG_ORIGIN));
            var radius = tag.method_10574(TAG_RADIUS);
            this.flight = new FlightAbility(true, timeLeft, dim, origin, radius);
        }
    }

    @Override
    public void writeToNbt(class_2487 tag) {
        tag.method_10556(TAG_ALLOWED, this.flight.allowed());
        if (this.flight.allowed()) {
            tag.method_10569(TAG_TIME_LEFT, this.flight.timeLeft());
            tag.method_10582(TAG_DIMENSION, this.flight.dimension().method_29177().toString());
            tag.method_10566(TAG_ORIGIN, HexUtils.serializeToNBT(this.flight.origin()));
            tag.method_10549(TAG_RADIUS, this.flight.radius());
        }
    }
}
