package at.petrak.hexcasting.fabric.cc;

import at.petrak.hexcasting.api.misc.FrozenColorizer;
import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import net.minecraft.class_1657;
import net.minecraft.class_2487;

/**
 * Holds the colorizer item favored by the player
 */
public class CCFavoredColorizer implements Component, AutoSyncedComponent {
    public static final String TAG_COLORIZER = "colorizer";

    private final class_1657 owner;

    public CCFavoredColorizer(class_1657 owner) {
        this.owner = owner;
    }

    private FrozenColorizer colorizer = FrozenColorizer.DEFAULT.get();

    public FrozenColorizer getColorizer() {
        return colorizer;
    }

    public void setColorizer(FrozenColorizer colorizer) {
        this.colorizer = colorizer;
        HexCardinalComponents.FAVORED_COLORIZER.sync(this.owner);
    }

    @Override
    public void readFromNbt(class_2487 tag) {
        this.colorizer = FrozenColorizer.fromNBT(tag.method_10562(TAG_COLORIZER));
    }

    @Override
    public void writeToNbt(class_2487 tag) {
        tag.method_10566(TAG_COLORIZER, this.colorizer.serializeToNBT());
    }
}
