package at.petrak.hexcasting.fabric.cc;

import at.petrak.hexcasting.api.addldata.DataHolder;
import at.petrak.hexcasting.api.item.DataHolderItem;
import at.petrak.hexcasting.api.spell.SpellDatum;
import dev.onyxstudios.cca.api.v3.item.ItemComponent;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public abstract class CCDataHolder extends ItemComponent implements DataHolder {
    public CCDataHolder(class_1799 stack) {
        super(stack, HexCardinalComponents.DATA_HOLDER);
    }

    public static class ItemBased extends CCDataHolder {
        private final DataHolderItem dataHolder;

        public ItemBased(class_1799 stack) {
            super(stack);
            if (!(stack.method_7909() instanceof DataHolderItem data)) {
                throw new IllegalStateException("item is not a data holder: " + stack);
            }
            this.dataHolder = data;
        }

        @Override
        public @Nullable class_2487 readRawDatum() {
            return this.dataHolder.readDatumTag(this.stack);
        }

        @Override
        public boolean writeDatum(@Nullable SpellDatum<?> datum, boolean simulate) {
            var canWrite = this.dataHolder.canWrite(this.stack, datum);
            if (!canWrite) {
                return false;
            }
            if (!simulate) {
                this.dataHolder.writeDatum(this.stack, datum);
            }
            return true;
        }
    }

    public static class Static extends CCDataHolder {
        private final Function<class_1799, SpellDatum<?>> provider;

        public Static(class_1799 stack, Function<class_1799, SpellDatum<?>> provider) {
            super(stack);
            this.provider = provider;
        }

        @Override
        public @Nullable class_2487 readRawDatum() {
            SpellDatum<?> datum = this.provider.apply(this.stack);
            return datum == null ? null : datum.serializeToNBT();
        }

        @Override
        public boolean writeDatum(@Nullable SpellDatum<?> datum, boolean simulate) {
            return false;
        }
    }
}
