package at.petrak.hexcasting.datagen.recipe.builders;

import at.petrak.hexcasting.common.recipe.HexRecipeSerializers;
import at.petrak.hexcasting.common.recipe.ingredient.StateIngredient;
import at.petrak.hexcasting.common.recipe.ingredient.StateIngredientHelper;
import at.petrak.hexcasting.common.recipe.ingredient.VillagerIngredient;
import com.google.gson.JsonObject;
import org.jetbrains.annotations.Nullable;
import record;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_1865;
import net.minecraft.class_193;
import net.minecraft.class_2119;
import net.minecraft.class_2444;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5797;

public class BrainsweepRecipeBuilder implements class_5797 {
    private StateIngredient blockIn;
    private VillagerIngredient villagerIn;
    private final class_2680 result;

    private final class_161.class_162 advancement;

    public BrainsweepRecipeBuilder(StateIngredient blockIn, VillagerIngredient villagerIn, class_2680 result) {
        this.blockIn = blockIn;
        this.villagerIn = villagerIn;
        this.result = result;
        this.advancement = class_161.class_162.method_707();
    }

    @Override
    public class_5797 method_33530(String pCriterionName, class_184 pCriterionTrigger) {
        this.advancement.method_709(pCriterionName, pCriterionTrigger);
        return this;
    }

    @Override
    public class_5797 method_33529(@Nullable String pGroupName) {
        return this;
    }

    @Override
    public class_1792 method_36441() {
        return this.result.method_26204().method_8389();
    }

    @Override
    public void method_17972(Consumer<class_2444> pFinishedRecipeConsumer, class_2960 pRecipeId) {
        if (this.advancement.method_710().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + pRecipeId);
        }

        this.advancement.method_708(new class_2960("recipes/root"))
            .method_709("has_the_recipe", class_2119.method_27847(pRecipeId))
            .method_703(class_170.class_171.method_753(pRecipeId))
            .method_704(class_193.field_1257);
        pFinishedRecipeConsumer.accept(new Result(
            pRecipeId,
            this.blockIn, this.villagerIn, this.result,
            this.advancement,
            new class_2960(pRecipeId.method_12836(), "recipes/brainsweep/" + pRecipeId.method_12832())));
    }

    public record Result(class_2960 id, StateIngredient blockIn, VillagerIngredient villagerIn,
                         class_2680 result, class_161.class_162 advancement,
                         class_2960 advancementId) implements FinishedRecipe {
        @Override
        public void serializeRecipeData(JsonObject json) {
            json.add("blockIn", this.blockIn.serialize());
            json.add("villagerIn", this.villagerIn.serialize());
            json.add("result", StateIngredientHelper.serializeBlockState(this.result));
        }

        @Override
        public class_2960 getId() {
            return this.id;
        }

        @Override
        public class_1865<?> getType() {
            return HexRecipeSerializers.BRAINSWEEP;
        }

        @Nullable
        @Override
        public JsonObject serializeAdvancement() {
            return this.advancement.method_698();
        }

        @Nullable
        @Override
        public class_2960 getAdvancementId() {
            return this.advancementId;
        }
    }
}
