package at.petrak.hexcasting.datagen.recipe;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.advancements.OvercastTrigger;
import at.petrak.hexcasting.api.mod.HexItemTags;
import at.petrak.hexcasting.common.items.ItemWand;
import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.recipe.SealFocusRecipe;
import at.petrak.hexcasting.common.recipe.SealSpellbookRecipe;
import at.petrak.hexcasting.common.recipe.ingredient.StateIngredientHelper;
import at.petrak.hexcasting.common.recipe.ingredient.VillagerIngredient;
import at.petrak.hexcasting.datagen.IXplatIngredients;
import at.petrak.hexcasting.datagen.recipe.builders.BrainsweepRecipeBuilder;
import at.petrak.paucal.api.datagen.PaucalRecipeProvider;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1866;
import net.minecraft.class_2048;
import net.minecraft.class_2096;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2444;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2456;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_3981;
import net.minecraft.data.recipes.*;
import var;
import java.util.function.Consumer;


public class HexplatRecipes extends PaucalRecipeProvider {
    public class_2403 generator;
    public IXplatIngredients ingredients;

    public HexplatRecipes(class_2403 pGenerator, IXplatIngredients ingredients) {
        super(pGenerator, HexAPI.MOD_ID);
        this.generator = pGenerator;
        this.ingredients = ingredients;
    }

    protected void makeRecipes(Consumer<class_2444> recipes) {
        specialRecipe(recipes, SealFocusRecipe.SERIALIZER);
        specialRecipe(recipes, SealSpellbookRecipe.SERIALIZER);

        wandRecipe(recipes, HexItems.WAND_OAK, class_1802.field_8118);
        wandRecipe(recipes, HexItems.WAND_BIRCH, class_1802.field_8191);
        wandRecipe(recipes, HexItems.WAND_SPRUCE, class_1802.field_8113);
        wandRecipe(recipes, HexItems.WAND_JUNGLE, class_1802.field_8842);
        wandRecipe(recipes, HexItems.WAND_DARK_OAK, class_1802.field_8404);
        wandRecipe(recipes, HexItems.WAND_ACACIA, class_1802.field_8651);
        wandRecipe(recipes, HexItems.WAND_CRIMSON, class_1802.field_22031);
        wandRecipe(recipes, HexItems.WAND_WARPED, class_1802.field_22032);
        wandRecipe(recipes, HexItems.WAND_AKASHIC, HexBlocks.AKASHIC_PLANKS.method_8389());

        ringCornered(HexItems.FOCUS, 1, ingredients.glowstoneDust(),
            ingredients.leather(), class_1856.method_8091(HexItems.CHARGED_AMETHYST))
            .method_10429("has_item", hasItem(HexItemTags.WANDS))
            .method_10431(recipes);

        class_2447.method_10437(HexItems.SPELLBOOK)
            .method_10428('N', ingredients.goldNugget())
            .method_10434('B', class_1802.field_8674)
            .method_10434('A', HexItems.CHARGED_AMETHYST)
            .method_10434('F', class_1802.field_8233) // i wanna gate this behind the end SOMEHOW
            // hey look its my gender ^^
            .method_10439("NBA")
            .method_10439("NFA")
            .method_10439("NBA")
            .method_10429("has_focus", hasItem(HexItems.FOCUS))
            .method_10429("has_chorus", hasItem(class_1802.field_8233)).method_10431(recipes);

        ringCornerless(HexItems.CYPHER, 1,
            ingredients.copperIngot(),
            class_1856.method_8091(HexItems.AMETHYST_DUST))
            .method_10429("has_item", hasItem(HexItemTags.WANDS)).method_10431(recipes);

        ringCornerless(HexItems.TRINKET, 1,
            ingredients.ironIngot(),
            class_1856.method_8091(class_1802.field_27063))
            .method_10429("has_item", hasItem(HexItemTags.WANDS)).method_10431(recipes);

        class_2447.method_10437(HexItems.ARTIFACT)
            .method_10428('F', ingredients.goldIngot())
            .method_10434('A', HexItems.CHARGED_AMETHYST)
            // why in god's name does minecraft have two different places for item tags
            .method_10433('D', class_3489.field_15541)
            .method_10439(" F ")
            .method_10439("FAF")
            .method_10439(" D ")
            .method_10429("has_item", hasItem(HexItemTags.WANDS)).method_10431(recipes);

        ringCornerless(HexItems.SCRYING_LENS, 1, class_1802.field_8280, HexItems.AMETHYST_DUST)
            .method_10429("has_item", hasItem(HexItemTags.WANDS)).method_10431(recipes);

        class_2447.method_10437(HexItems.ABACUS)
            .method_10434('S', class_1802.field_8600)
            .method_10434('A', class_1802.field_27063)
            .method_10433('W', class_3489.field_15537)
            .method_10439("WAW")
            .method_10439("SAS")
            .method_10439("WAW")
            .method_10429("has_item", hasItem(HexItemTags.WANDS)).method_10431(recipes);

        // Why am I like this
        class_2447.method_10437(HexItems.SUBMARINE_SANDWICH)
            .method_10434('S', class_1802.field_8600)
            .method_10434('A', class_1802.field_27063)
            .method_10434('C', class_1802.field_8176)
            .method_10434('B', class_1802.field_8229)
            .method_10439(" SA")
            .method_10439(" C ")
            .method_10439(" B ")
            .method_10429("has_item", hasItem(class_1802.field_27063)).method_10431(recipes);

        for (var dye : class_1767.values()) {
            var item = HexItems.DYE_COLORIZERS.get(dye);
            class_2447.method_10437(item)
                .define('B', class_1802.field_8428)
                .define('D', HexItems.AMETHYST_DUST)
                .define('C', class_1769.method_7803(dye))
                .pattern(" C ")
                .pattern(" D ")
                .pattern(" B ")
                .unlockedBy("has_item", hasItem(HexItems.AMETHYST_DUST)).save(recipes);
        }

        gayRecipe(recipes, HexItems.PRIDE_COLORIZERS[0], class_1802.field_8803); // Trans
        gayRecipe(recipes, HexItems.PRIDE_COLORIZERS[1], class_1802.field_8337); // Gay
        gayRecipe(recipes, HexItems.PRIDE_COLORIZERS[2], class_1802.field_8280); // Agender
        gayRecipe(recipes, HexItems.PRIDE_COLORIZERS[3], class_1802.field_8229); // Asexual
        gayRecipe(recipes, HexItems.PRIDE_COLORIZERS[4], class_1802.field_8861); // Bisexual
        gayRecipe(recipes, HexItems.PRIDE_COLORIZERS[5], class_1802.field_8179); // Pansexual
        gayRecipe(recipes, HexItems.PRIDE_COLORIZERS[6], class_1802.field_8469); // Genderqueer
        gayRecipe(recipes, HexItems.PRIDE_COLORIZERS[7], class_1802.field_33401); // Demigirl
        gayRecipe(recipes, HexItems.PRIDE_COLORIZERS[8], class_1802.field_28654); // Non-Binary
        gayRecipe(recipes, HexItems.PRIDE_COLORIZERS[9], class_1802.field_20414); // Lesbian
        gayRecipe(recipes, HexItems.PRIDE_COLORIZERS[10], class_1802.field_33400); // Demiboy
        gayRecipe(recipes, HexItems.PRIDE_COLORIZERS[11], class_1802.field_8705); // Genderfluid
        gayRecipe(recipes, HexItems.PRIDE_COLORIZERS[12], class_1802.field_28650); // Intersex
        gayRecipe(recipes, HexItems.PRIDE_COLORIZERS[13], class_1802.field_8107); // Aroace

        class_2447.method_10437(HexItems.UUID_COLORIZER)
            .method_10434('B', class_1802.field_8428)
            .method_10434('D', HexItems.AMETHYST_DUST)
            .method_10434('C', class_1802.field_27063)
            .method_10439(" C ")
            .method_10439(" D ")
            .method_10439(" B ")
            .method_10429("has_item", hasItem(HexItems.AMETHYST_DUST)).method_10431(recipes);

        class_2447.method_10437(HexItems.SCROLL)
            .method_10434('P', class_1802.field_8407)
            .method_10434('A', class_1802.field_27063)
            .method_10439("  A")
            .method_10439("PP ")
            .method_10439("PP ")
            .method_10429("has_item", hasItem(class_1802.field_27063)).method_10431(recipes);

        class_2447.method_10436(HexItems.SLATE, 6)
            .method_10434('S', class_1802.field_28866)
            .method_10434('A', HexItems.AMETHYST_DUST)
            .method_10439(" A ")
            .method_10439("SSS")
            .method_10429("has_item", hasItem(HexItems.AMETHYST_DUST)).method_10431(recipes);

        class_2447.method_10437(HexItems.JEWELER_HAMMER)
            .method_10428('I', ingredients.ironIngot())
            .method_10428('N', ingredients.ironNugget())
            .method_10434('A', class_1802.field_27063)
            .method_10428('S', ingredients.stick())
            .method_10439("IAN")
            .method_10439(" S ")
            .method_10439(" S ")
            .method_10429("has_item", hasItem(class_1802.field_27063)).method_10431(recipes);

        class_2447.method_10437(HexBlocks.SLATE_BLOCK)
            .method_10434('S', HexItems.SLATE)
            .method_10439("S")
            .method_10439("S")
            .method_10429("has_item", hasItem(HexItems.SLATE))
            .method_17972(recipes, modLoc("slate_block_from_slates"));

        ringAll(HexBlocks.SLATE_BLOCK, 8, class_2246.field_28888, HexItems.AMETHYST_DUST)
            .method_10429("has_item", hasItem(HexItems.SLATE)).method_10431(recipes);

        packing(HexItems.AMETHYST_DUST, HexBlocks.AMETHYST_DUST_BLOCK.method_8389(), "amethyst_dust",
            false, recipes);

        ringAll(HexBlocks.AMETHYST_TILES, 8, class_2246.field_27159, HexItems.AMETHYST_DUST)
            .method_10429("has_item", hasItem(HexItems.AMETHYST_DUST)).method_10431(recipes);
        class_3981.method_17968(class_1856.method_8091(class_2246.field_27159), HexBlocks.AMETHYST_TILES)
            .method_17970("has_item", hasItem(class_2246.field_27159))
            .method_17972(recipes, modLoc("stonecutting/amethyst_tiles"));

        ringAll(HexBlocks.SCROLL_PAPER, 8, class_1802.field_8407, class_1802.field_27063)
            .method_10429("has_item", hasItem(class_1802.field_27063)).method_10431(recipes);
        class_2450.method_10448(HexBlocks.ANCIENT_SCROLL_PAPER, 8)
            .method_10451(ingredients.dyes().get(class_1767.field_7957))
            .method_10449(HexBlocks.SCROLL_PAPER, 8)
            .method_10442("has_item", hasItem(HexBlocks.SCROLL_PAPER)).method_10431(recipes);
        stack(HexBlocks.SCROLL_PAPER_LANTERN, 1, HexBlocks.SCROLL_PAPER, class_1802.field_8810)
            .method_10429("has_item", hasItem(HexBlocks.SCROLL_PAPER)).method_10431(recipes);
        stack(HexBlocks.ANCIENT_SCROLL_PAPER_LANTERN, 1, HexBlocks.ANCIENT_SCROLL_PAPER, class_1802.field_8810)
            .method_10429("has_item", hasItem(HexBlocks.ANCIENT_SCROLL_PAPER)).method_10431(recipes);
        class_2450.method_10448(HexBlocks.ANCIENT_SCROLL_PAPER_LANTERN, 8)
            .method_10451(ingredients.dyes().get(class_1767.field_7957))
            .method_10449(HexBlocks.SCROLL_PAPER_LANTERN, 8)
            .method_10442("has_item", hasItem(HexBlocks.SCROLL_PAPER_LANTERN))
            .method_17972(recipes, modLoc("ageing_scroll_paper_lantern"));

        stack(HexBlocks.SCONCE, 4, class_1856.method_8091(HexItems.CHARGED_AMETHYST),
            ingredients.copperIngot())
            .method_10429("has_item", hasItem(HexItems.CHARGED_AMETHYST)).method_10431(recipes);

        class_2450.method_10448(HexBlocks.AKASHIC_PLANKS, 4)
            .method_10446(HexItemTags.AKASHIC_LOGS)
            .method_10442("has_item", hasItem(HexItemTags.AKASHIC_LOGS)).method_10431(recipes);
        class_2447.method_10436(HexBlocks.AKASHIC_WOOD, 3)
            .method_10434('W', HexBlocks.AKASHIC_LOG)
            .method_10439("WW")
            .method_10439("WW")
            .method_10429("has_item", hasItem(HexBlocks.AKASHIC_LOG)).method_10431(recipes);
        class_2447.method_10436(HexBlocks.AKASHIC_WOOD_STRIPPED, 3)
            .method_10434('W', HexBlocks.AKASHIC_LOG_STRIPPED)
            .method_10439("WW")
            .method_10439("WW")
            .method_10429("has_item", hasItem(HexBlocks.AKASHIC_LOG_STRIPPED)).method_10431(recipes);
        ring(HexBlocks.AKASHIC_PANEL, 8, HexItemTags.AKASHIC_PLANKS, null)
            .method_10429("has_item", hasItem(HexItemTags.AKASHIC_PLANKS)).method_10431(recipes);
        class_2447.method_10436(HexBlocks.AKASHIC_TILE, 6)
            .method_10433('W', HexItemTags.AKASHIC_PLANKS)
            .method_10439("WW ")
            .method_10439("W W")
            .method_10439(" WW")
            .method_10429("has_item", hasItem(HexItemTags.AKASHIC_PLANKS)).method_10431(recipes);
        class_2447.method_10436(HexBlocks.AKASHIC_DOOR, 3)
            .method_10433('W', HexItemTags.AKASHIC_PLANKS)
            .method_10439("WW")
            .method_10439("WW")
            .method_10439("WW")
            .method_10429("has_item", hasItem(HexItemTags.AKASHIC_PLANKS)).method_10431(recipes);
        class_2447.method_10436(HexBlocks.AKASHIC_TRAPDOOR, 2)
            .method_10433('W', HexItemTags.AKASHIC_PLANKS)
            .method_10439("WWW")
            .method_10439("WWW")
            .method_10429("has_item", hasItem(HexItemTags.AKASHIC_PLANKS)).method_10431(recipes);
        class_2447.method_10436(HexBlocks.AKASHIC_STAIRS, 4)
            .method_10433('W', HexItemTags.AKASHIC_PLANKS)
            .method_10439("W  ")
            .method_10439("WW ")
            .method_10439("WWW")
            .method_10429("has_item", hasItem(HexItemTags.AKASHIC_PLANKS)).method_10431(recipes);
        class_2447.method_10436(HexBlocks.AKASHIC_SLAB, 6)
            .method_10433('W', HexItemTags.AKASHIC_PLANKS)
            .method_10439("WWW")
            .method_10429("has_item", hasItem(HexItemTags.AKASHIC_PLANKS)).method_10431(recipes);
        class_2447.method_10436(HexBlocks.AKASHIC_PRESSURE_PLATE, 1)
            .method_10433('W', HexItemTags.AKASHIC_PLANKS)
            .method_10439("WW")
            .method_10429("has_item", hasItem(HexItemTags.AKASHIC_PLANKS)).method_10431(recipes);
        class_2450.method_10447(HexBlocks.AKASHIC_BUTTON)
            .method_10446(HexItemTags.AKASHIC_PLANKS)
            .method_10442("has_item", hasItem(HexItemTags.AKASHIC_PLANKS)).method_10431(recipes);

        var enlightenment = new OvercastTrigger.Instance(class_2048.class_5258.field_24388,
            class_2096.class_2100.field_9708,
            // add a little bit of slop here
            class_2096.class_2099.method_9050(0.8),
            class_2096.class_2099.method_35285(0.1, 2.05));

        class_2447.method_10437(HexBlocks.EMPTY_IMPETUS)
            .method_10434('B', class_1802.field_8076)
            .method_10434('A', HexItems.CHARGED_AMETHYST)
            .method_10434('S', HexBlocks.SLATE_BLOCK)
            .method_10434('P', class_1802.field_20393)
            .method_10439("PSS")
            .method_10439("BAB")
            .method_10439("SSP")
            .method_10429("enlightenment", enlightenment).save(recipes);

        class_2447.method_10437(HexBlocks.EMPTY_DIRECTRIX)
            .method_10434('C', class_1802.field_8857)
            .method_10434('O', class_1802.field_8537)
            .method_10434('A', HexItems.CHARGED_AMETHYST)
            .method_10434('S', HexBlocks.SLATE_BLOCK)
            .method_10439("CSS")
            .method_10439("OAO")
            .method_10439("SSC")
            .method_10429("enlightenment", enlightenment).save(recipes);

        class_2447.method_10437(HexBlocks.AKASHIC_BOOKSHELF)
            .method_10433('L', HexItemTags.AKASHIC_LOGS)
            .method_10433('P', HexItemTags.AKASHIC_PLANKS)
            .method_10434('C', class_1802.field_8529)
            /*this is the*/.method_10439("LPL") // and what i have for you today is
            .method_10439("CCC")
            .method_10439("LPL")
            .method_10429("enlightenment", enlightenment).save(recipes);
        class_2447.method_10437(HexBlocks.AKASHIC_CONNECTOR)
            .method_10433('L', HexItemTags.AKASHIC_LOGS)
            .method_10433('P', HexItemTags.AKASHIC_PLANKS)
            .method_10434('C', HexItems.CHARGED_AMETHYST)
            .method_10439("LPL")
            .method_10439("CCC")
            .method_10439("LPL")
            .method_10429("enlightenment", enlightenment).save(recipes);

        new BrainsweepRecipeBuilder(StateIngredientHelper.of(class_2246.field_27159),
            new VillagerIngredient(null, null, 3),
            class_2246.field_27160.method_9564())
            .method_33530("enlightenment", enlightenment)
            .save(recipes, modLoc("brainsweep/budding_amethyst"));

        new BrainsweepRecipeBuilder(StateIngredientHelper.of(HexBlocks.EMPTY_IMPETUS),
            new VillagerIngredient(new class_2960("toolsmith"), null, 2),
            HexBlocks.IMPETUS_RIGHTCLICK.method_9564())
            .method_33530("enlightenment", enlightenment)
            .save(recipes, modLoc("brainsweep/impetus_rightclick"));
        new BrainsweepRecipeBuilder(StateIngredientHelper.of(HexBlocks.EMPTY_IMPETUS),
            new VillagerIngredient(new class_2960("fletcher"), null, 2),
            HexBlocks.IMPETUS_LOOK.method_9564())
            .method_33530("enlightenment", enlightenment)
            .save(recipes, modLoc("brainsweep/impetus_look"));
        new BrainsweepRecipeBuilder(StateIngredientHelper.of(HexBlocks.EMPTY_IMPETUS),
            new VillagerIngredient(new class_2960("cleric"), null, 2),
            HexBlocks.IMPETUS_STOREDPLAYER.method_9564())
            .method_33530("enlightenment", enlightenment)
            .save(recipes, modLoc("brainsweep/impetus_storedplayer"));

        new BrainsweepRecipeBuilder(StateIngredientHelper.of(HexBlocks.EMPTY_DIRECTRIX),
            new VillagerIngredient(new class_2960("mason"), null, 1),
            HexBlocks.DIRECTRIX_REDSTONE.method_9564())
            .method_33530("enlightenment", enlightenment)
            .save(recipes, modLoc("brainsweep/directrix_redstone"));

        new BrainsweepRecipeBuilder(StateIngredientHelper.of(HexBlocks.AKASHIC_CONNECTOR),
            new VillagerIngredient(new class_2960("librarian"), null, 5),
            HexBlocks.AKASHIC_RECORD.method_9564())
            .method_33530("enlightenment", enlightenment)
            .save(recipes, modLoc("brainsweep/akashic_record"));
    }

    private void wandRecipe(Consumer<class_2444> recipes, ItemWand wand, class_1792 plank) {
        class_2447.method_10437(wand)
            .method_10434('W', plank)
            .method_10434('S', class_1802.field_8600)
            .method_10434('A', HexItems.CHARGED_AMETHYST)
            .method_10439(" SA")
            .method_10439(" WS")
            .method_10439("S  ")
            .method_10429("has_item", hasItem(HexItems.CHARGED_AMETHYST))
            .method_10431(recipes);
    }

    private void gayRecipe(Consumer<class_2444> recipes, class_1792 colorizer, class_1792 material) {
        class_2447.method_10437(colorizer)
            .method_10434('B', class_1802.field_8428)
            .method_10434('D', HexItems.AMETHYST_DUST)
            .method_10434('C', material)
            .method_10439(" C ")
            .method_10439(" D ")
            .method_10439(" B ")
            .method_10429("has_item", hasItem(HexItems.AMETHYST_DUST)).method_10431(recipes);
    }

    protected void specialRecipe(Consumer<class_2444> consumer, class_1866<?> serializer) {
        var name = class_2378.field_17598.method_10221(serializer);
        class_2456.method_10476(serializer).method_10475(consumer, HexAPI.MOD_ID + ":dynamic/" + name.getPath());
    }
}
