package at.petrak.hexcasting.datagen;

import at.petrak.hexcasting.common.blocks.circles.BlockEntitySlate;
import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.loot.HexLootHandler;
import at.petrak.hexcasting.common.loot.PatternScrollFunc;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import at.petrak.paucal.api.datagen.PaucalLootTableProvider;
import net.minecraft.class_104;
import net.minecraft.class_141;
import net.minecraft.class_182;
import net.minecraft.class_186;
import net.minecraft.class_1893;
import net.minecraft.class_2035;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_212;
import net.minecraft.class_223;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2403;
import net.minecraft.class_2482;
import net.minecraft.class_2756;
import net.minecraft.class_2771;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_3837;
import net.minecraft.class_44;
import net.minecraft.class_4559;
import net.minecraft.class_52;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5646;
import net.minecraft.class_5662;
import net.minecraft.class_77;
import net.minecraft.class_94;
import net.minecraft.world.level.storage.loot.predicates.*;
import var;
import java.util.Map;

import static at.petrak.hexcasting.api.HexAPI.modLoc;

public class HexLootTables extends PaucalLootTableProvider {
    public HexLootTables(class_2403 pGenerator) {
        super(pGenerator);
    }

    @Override
    protected void makeLootTables(Map<class_2248, class_52.class_53> blockTables,
        Map<class_2960, class_52.class_53> lootTables) {
        dropSelf(blockTables, HexBlocks.EMPTY_IMPETUS,
            HexBlocks.IMPETUS_RIGHTCLICK, HexBlocks.IMPETUS_LOOK, HexBlocks.IMPETUS_STOREDPLAYER,
            HexBlocks.DIRECTRIX_REDSTONE, HexBlocks.EMPTY_DIRECTRIX,
            HexBlocks.AKASHIC_RECORD, HexBlocks.AKASHIC_BOOKSHELF, HexBlocks.AKASHIC_CONNECTOR,
            HexBlocks.SLATE_BLOCK, HexBlocks.AMETHYST_DUST_BLOCK, HexBlocks.AMETHYST_TILES, HexBlocks.SCROLL_PAPER,
            HexBlocks.ANCIENT_SCROLL_PAPER, HexBlocks.SCROLL_PAPER_LANTERN, HexBlocks.ANCIENT_SCROLL_PAPER_LANTERN,
            HexBlocks.SCONCE,
            HexBlocks.AKASHIC_LOG, HexBlocks.AKASHIC_LOG_STRIPPED, HexBlocks.AKASHIC_WOOD,
            HexBlocks.AKASHIC_WOOD_STRIPPED,
            HexBlocks.AKASHIC_PLANKS, HexBlocks.AKASHIC_TILE, HexBlocks.AKASHIC_PANEL,
            HexBlocks.AKASHIC_TRAPDOOR, HexBlocks.AKASHIC_STAIRS, HexBlocks.AKASHIC_PRESSURE_PLATE,
            HexBlocks.AKASHIC_BUTTON);

        makeSlabTable(blockTables, HexBlocks.AKASHIC_SLAB);

        makeLeafTable(blockTables, HexBlocks.AKASHIC_LEAVES1);
        makeLeafTable(blockTables, HexBlocks.AKASHIC_LEAVES2);
        makeLeafTable(blockTables, HexBlocks.AKASHIC_LEAVES3);

        var slatePool = class_55.method_347()
            .method_352(class_44.method_32448(1))
            .method_351(class_77.method_411(HexBlocks.SLATE)
                .method_438(class_3837.method_16848(class_5646.field_27914)
                    .method_16856(BlockEntitySlate.TAG_PATTERN, "BlockEntityTag." + BlockEntitySlate.TAG_PATTERN)));
        blockTables.put(HexBlocks.SLATE, class_52.method_324().method_336(slatePool));

        var doorPool = dropThisPool(HexBlocks.AKASHIC_DOOR, 1)
            .method_356(new class_212.class_213(HexBlocks.AKASHIC_DOOR).method_22584(
                class_4559.class_4560.method_22523().method_22525(class_2323.field_10946, class_2756.field_12607)
            ));
        blockTables.put(HexBlocks.AKASHIC_DOOR, class_52.method_324().method_336(doorPool));


        var noSilkTouchCond = class_223.method_945(
                class_2073.class_2074.method_8973().method_8978(
                    new class_2035(class_1893.field_9099, class_2096.class_2100.field_9708)))
            .method_16780();
        var goodAtAmethystingCond = class_223.method_945(
            class_2073.class_2074.method_8973().method_8975(class_3489.field_29544)
        );
        var dustPool = class_55.method_347()
            .method_351(class_77.method_411(HexItems.AMETHYST_DUST))
            .method_353(class_141.method_621(class_5662.method_32462(1, 4)))
            .method_353(class_94.method_455(class_1893.field_9130))
            .method_356(noSilkTouchCond).when(goodAtAmethystingCond);
        var isThatAnMFingBrandonSandersonReference = class_55.method_347()
            .method_351(class_77.method_411(HexItems.CHARGED_AMETHYST))
            .method_353(class_141.method_621(class_44.method_32448(1)))
            .method_356(noSilkTouchCond).when(goodAtAmethystingCond)
            .when(class_182.method_800(class_1893.field_9130,
                0.25f, 0.35f, 0.5f, 0.75f, 1.0f));
        lootTables.put(HexLootHandler.TABLE_INJECT_AMETHYST_CLUSTER, class_52.method_324()
            .method_336(dustPool)
            .withPool(isThatAnMFingBrandonSandersonReference));

        String[] rarities = new String[]{
            "few",
            "some",
            "many"
        };
        for (int i = 0; i < rarities.length; i++) {
            var scrollPool = makeScrollAdder(i + 1);
            lootTables.put(modLoc("inject/scroll_loot_" + rarities[i]), scrollPool);
        }
    }

    private void makeLeafTable(Map<class_2248, class_52.class_53> lootTables, class_2248 block) {
        var leafPool = dropThisPool(block, 1)
            .method_356(new class_186.class_187(
                IXplatAbstractions.INSTANCE.isShearsCondition(),
                class_223.method_945(class_2073.class_2074.method_8973()
                    .method_8978(new class_2035(class_1893.field_9099, class_2096.class_2100.method_9053(1))))
            ));
        lootTables.put(block, class_52.method_324().method_336(leafPool));
    }

    private void makeSlabTable(Map<class_2248, class_52.class_53> lootTables, class_2248 block) {
        var leafPool = dropThisPool(block, 1)
            .method_353(class_141.method_621(class_44.method_32448(2))
                .method_524(new class_212.class_213(block).method_22584(
                    class_4559.class_4560.method_22523().method_22525(class_2482.field_11501, class_2771.field_12682)
                )))
            .method_353(class_104.method_478());
        lootTables.put(block, class_52.method_324().method_336(leafPool));
    }

    // "stddev"
    private class_52.class_53 makeScrollAdder(float stddev) {
        var pool = class_55.method_347()
            .method_352(class_5662.method_32462(-stddev, stddev))
            .method_351(class_77.method_411(HexItems.SCROLL))
            .method_353(() -> new PatternScrollFunc(new class_5341[0]));
        return class_52.method_324().method_336(pool);
    }
}
