package at.petrak.hexcasting.datagen;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.advancements.FailToCastGreatSpellTrigger;
import at.petrak.hexcasting.api.advancements.OvercastTrigger;
import at.petrak.hexcasting.api.advancements.SpendManaTrigger;
import at.petrak.hexcasting.api.misc.ManaConstants;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.paucal.api.datagen.PaucalAdvancementProvider;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_185;
import net.minecraft.class_189;
import net.minecraft.class_2048;
import net.minecraft.class_2066;
import net.minecraft.class_2096;
import net.minecraft.class_2403;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import var;

public class HexAdvancements extends PaucalAdvancementProvider {
    public HexAdvancements(class_2403 generatorIn) {
        super(generatorIn, HexAPI.MOD_ID);
    }

    @Override
    protected void makeAdvancements(Consumer<class_161> consumer) {
        var root = class_161.class_162.method_707()
            // what an ergonomic design decision
            // i am so happy that data generators are the future
            .method_693(new class_185(new class_1799(class_1802.field_27065),
                new class_2588("advancement.hexcasting:root"),
                new class_2588("advancement.hexcasting:root.desc"),
                new class_2960("minecraft", "textures/block/calcite.png"),
                class_189.field_1254, true, true, true))
            // the only thing making this vaguely tolerable is the knowledge the json files are worse somehow
            .method_709("has_charged_amethyst",
                class_2066.class_2068.method_8959(HexItems.CHARGED_AMETHYST))
            .method_694(consumer, prefix("root")); // how the hell does one even read this

        // weird names so we have alphabetical parity
        class_161.class_162.method_707()
            .method_693(simpleDisplay(class_1802.field_8597, "wasteful_cast", class_189.field_1254))
            .method_701(root)
            .addCriterion("waste_amt", new SpendManaTrigger.Instance(class_2048.class_5258.field_24388,
                class_2096.class_2100.field_9708,
                class_2096.class_2100.method_9053(89 * ManaConstants.DUST_UNIT / 10)))
            .save(consumer, prefix("aaa_wasteful_cast"));
        class_161.class_162.method_707()
            .method_693(simpleDisplay(HexItems.CHARGED_AMETHYST, "big_cast", class_189.field_1254))
            .method_701(root)
            .addCriterion("cast_amt", new SpendManaTrigger.Instance(class_2048.class_5258.field_24388,
                class_2096.class_2100.method_9053(64 * ManaConstants.CRYSTAL_UNIT),
                class_2096.class_2100.field_9708))
            .save(consumer, prefix("aab_big_cast"));

        var impotence = class_161.class_162.method_707()
            .method_693(simpleDisplay(class_1802.field_8183, "y_u_no_cast_angy", class_189.field_1254))
            .method_701(root)
            .addCriterion("did_the_thing",
                new FailToCastGreatSpellTrigger.Instance(class_2048.class_5258.field_24388))
            .save(consumer, prefix("y_u_no_cast_angy"));

        var opened_eyes = class_161.class_162.method_707()
            .method_693(simpleDisplay(class_1802.field_8449, "opened_eyes", class_189.field_1254))
            .method_701(impotence)
            .addCriterion("health_used",
                new OvercastTrigger.Instance(class_2048.class_5258.field_24388,
                    class_2096.class_2100.field_9708,
                    class_2096.class_2099.field_9705,
                    // you can't just kill yourself
                    class_2096.class_2099.method_9050(0.1)))
            .save(consumer, prefix("opened_eyes"));

        class_161.class_162.method_707()
            .method_693(new class_185(new class_1799(class_1802.field_8731),
                new class_2588("advancement.hexcasting:enlightenment"),
                new class_2588("advancement.hexcasting:enlightenment.desc"),
                null,
                class_189.field_1250, true, true, true))
            .method_701(opened_eyes)
            .addCriterion("health_used",
                new OvercastTrigger.Instance(class_2048.class_5258.field_24388,
                    class_2096.class_2100.field_9708,
                    // add a little bit of slop here
                    class_2096.class_2099.method_9050(0.8),
                    class_2096.class_2099.method_35285(0.1, 2.05)))
            .save(consumer, prefix("enlightenment"));

//        super.registerAdvancements(consumer, fileHelper);
    }
}
