package at.petrak.hexcasting.common.recipe.ingredient;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;

public class StateIngredientBlocks implements StateIngredient {
    protected final ImmutableSet<class_2248> blocks;

    public StateIngredientBlocks(Collection<class_2248> blocks) {
        this.blocks = ImmutableSet.copyOf(blocks);
    }

    @Override
    public boolean test(class_2680 state) {
        return blocks.contains(state.method_26204());
    }

    @Override
    public class_2680 pick(Random random) {
        return blocks.asList().get(random.nextInt(blocks.size())).method_9564();
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "blocks");
        JsonArray array = new JsonArray();
        for (class_2248 block : blocks) {
            array.add(class_2378.field_11146.method_10221(block).toString());
        }
        object.add("blocks", array);
        return object;
    }

    @Override
    public void write(class_2540 buffer) {
        List<class_2248> blocks = getBlocks();
        buffer.method_10804(0);
        buffer.method_10804(blocks.size());
        for (class_2248 block : blocks) {
            buffer.method_10804(class_2378.field_11146.method_10206(block));
        }
    }

    @Override
    public List<class_1799> getDisplayedStacks() {
        return blocks.stream()
            .filter(b -> b.method_8389() != class_1802.field_8162)
            .map(class_1799::new)
            .collect(Collectors.toList());
    }

    @Override
    public List<class_2680> getDisplayed() {
        return blocks.stream().map(class_2248::method_9564).collect(Collectors.toList());
    }

    @Nonnull
    protected List<class_2248> getBlocks() {
        return blocks.asList();
    }

    @Override
    public String toString() {
        return "StateIngredientBlocks{" + blocks.toString() + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        return blocks.equals(((StateIngredientBlocks) o).blocks);
    }

    @Override
    public int hashCode() {
        return Objects.hash(blocks);
    }
}
