package at.petrak.hexcasting.common.recipe.ingredient;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import java.util.*;

public class StateIngredientBlockState implements StateIngredient {
    private final class_2680 state;

    public StateIngredientBlockState(class_2680 state) {
        this.state = state;
    }

    @Override
    public boolean test(class_2680 blockState) {
        return this.state == blockState;
    }

    @Override
    public class_2680 pick(Random random) {
        return state;
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = StateIngredientHelper.serializeBlockState(state);
        object.addProperty("type", "state");
        return object;
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10804(2);
        buffer.method_10804(class_2248.method_9507(state));
    }

    @Override
    public List<class_1799> getDisplayedStacks() {
        class_2248 block = state.method_26204();
        if (block.method_8389() == class_1802.field_8162) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new class_1799(block));
    }

    @Nullable
    @Override
    public List<class_2561> descriptionTooltip() {
        ImmutableMap<class_2769<?>, Comparable<?>> map = state.method_11656();
        if (map.isEmpty()) {
            return StateIngredient.super.descriptionTooltip();
        }
        List<class_2561> tooltip = new ArrayList<>(map.size());
        for (Map.Entry<class_2769<?>, Comparable<?>> entry : map.entrySet()) {
            class_2769<?> key = entry.getKey();
            @SuppressWarnings({"unchecked", "rawtypes"})
            String name = ((class_2769) key).method_11901(entry.getValue());

            tooltip.add(new class_2585(key.method_11899() + " = " + name).method_27692(class_124.field_1080));
        }
        return tooltip;
    }

    @Override
    public List<class_2680> getDisplayed() {
        return Collections.singletonList(state);
    }

    public class_2680 getState() {
        return state;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        return state == ((StateIngredientBlockState) o).state;
    }

    @Override
    public int hashCode() {
        return state.hashCode();
    }

    @Override
    public String toString() {
        return "StateIngredientBlockState{" + state + "}";
    }
}