package at.petrak.hexcasting.common.recipe.ingredient;

import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2680;

public class StateIngredientBlock implements StateIngredient {
    private final class_2248 block;

    public StateIngredientBlock(class_2248 block) {
        this.block = block;
    }

    @Override
    public boolean test(class_2680 blockState) {
        return block == blockState.method_26204();
    }

    @Override
    public class_2680 pick(Random random) {
        return block.method_9564();
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "block");
        object.addProperty("block", class_2378.field_11146.method_10221(block).toString());
        return object;
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10804(1);
        buffer.method_10804(class_2378.field_11146.method_10206(block));
    }

    @Override
    public List<class_1799> getDisplayedStacks() {
        if (block.method_8389() == class_1802.field_8162) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new class_1799(block));
    }

    @Override
    public List<class_2680> getDisplayed() {
        return Collections.singletonList(block.method_9564());
    }

    public class_2248 getBlock() {
        return block;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        return block == ((StateIngredientBlock) o).block;
    }

    @Override
    public int hashCode() {
        return block.hashCode();
    }

    @Override
    public String toString() {
        return "StateIngredientBlock{" + block + "}";
    }
}