package at.petrak.hexcasting.common.recipe;

import at.petrak.hexcasting.api.item.DataHolderItem;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.items.ItemSpellbook;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1867;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import var;

public class SealSpellbookRecipe extends class_1867 {
    public static final class_1866<SealSpellbookRecipe> SERIALIZER =
        new class_1866<>(SealSpellbookRecipe::new);

    private static class_1799 getSealedStack() {
        class_1799 output = new class_1799(HexItems.SPELLBOOK);
        ItemSpellbook.SetSealed(output, true);
        NBTHelper.putString(output, DataHolderItem.TAG_OVERRIDE_VISUALLY, "any");
        return output;
    }

    private static class_2371<class_1856> createIngredients() {
        class_2371<class_1856> ingredients = class_2371.method_37434(2);
        ingredients.add(IXplatAbstractions.INSTANCE.getUnsealedIngredient(new class_1799(HexItems.SPELLBOOK)));
        ingredients.add(class_1856.method_8091(class_1802.field_20414));
        return ingredients;
    }

    public SealSpellbookRecipe(class_2960 id) {
        super(id, "", getSealedStack(), createIngredients());
    }

    @Override
    public @NotNull class_1799 method_17729(class_1715 inv) {
        class_1799 out = class_1799.field_8037;

        for (int i = 0; i < inv.method_5439(); i++) {
            var stack = inv.method_5438(i);
            if (stack.is(HexItems.SPELLBOOK)) {
                out = stack.copy();
                break;
            }
        }

        if (!out.method_7960()) {
            ItemSpellbook.SetSealed(out, true);
            out.method_7939(1);
        }

        return out;
    }

    @Override
    public @NotNull class_1865<?> method_8119() {
        return SERIALIZER;
    }
}

