package at.petrak.hexcasting.common.recipe;

import at.petrak.hexcasting.api.HexAPI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import var;

import static at.petrak.hexcasting.api.HexAPI.modLoc;

public class HexRecipeSerializers {
    public static void registerSerializers(BiConsumer<class_1865<?>, class_2960> r) {
        for (var e : SERIALIZERS.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    private static final Map<class_2960, class_1865<?>> SERIALIZERS = new LinkedHashMap<>();

    public static final class_1865<?> BRAINSWEEP = register("brainsweep", new BrainsweepRecipe.Serializer());
    public static class_3956<BrainsweepRecipe> BRAINSWEEP_TYPE;
    public static final class_1865<SealFocusRecipe> SEAL_FOCUS = register("seal_focus",
        SealFocusRecipe.SERIALIZER);
    public static final class_1865<SealSpellbookRecipe> SEAL_SPELLBOOK = register(
        "seal_spellbook",
        SealSpellbookRecipe.SERIALIZER);

    private static <T extends class_1860<?>> class_1865<T> register(String name, class_1865<T> rs) {
        var old = SERIALIZERS.put(modLoc(name), rs);
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + name);
        }
        return rs;
    }

    // Like in the statistics, gotta register it at some point
    public static void registerTypes() {
        BRAINSWEEP_TYPE = class_3956.method_17726(HexAPI.MOD_ID + ":brainsweep");
    }
}
