package at.petrak.hexcasting.common.recipe;

import at.petrak.hexcasting.common.recipe.ingredient.StateIngredient;
import at.petrak.hexcasting.common.recipe.ingredient.StateIngredientHelper;
import at.petrak.hexcasting.common.recipe.ingredient.VillagerIngredient;
import com.google.gson.JsonObject;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.jetbrains.annotations.NotNull;
import var;

// God I am a horrible person
public record BrainsweepRecipe(
    ResourceLocation id,
    StateIngredient blockIn,
    VillagerIngredient villagerIn,
    BlockState result
) implements Recipe<Container> {
    public boolean matches(BlockState blockIn, Villager villagerIn) {
        return this.blockIn.test(blockIn) && this.villagerIn.test(villagerIn);
    }

    @Override
    public ResourceLocation getId() {
        return id;
    }

    @Override
    public RecipeType<?> getType() {
        return HexRecipeSerializers.BRAINSWEEP_TYPE;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return HexRecipeSerializers.BRAINSWEEP;
    }

    // in order to get this to be a "Recipe" we need to do a lot of bending-over-backwards
    // to get the implementation to be satisfied even though we never use it
    @Override
    public boolean matches(Container pContainer, Level pLevel) {
        return false;
    }

    @Override
    public ItemStack assemble(Container pContainer) {
        return ItemStack.EMPTY;
    }

    @Override
    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    @Override
    public ItemStack getResultItem() {
        return ItemStack.EMPTY.copy();
    }

    // Because kotlin doesn't like doing raw, unchecked types
    // Can't blame it, but that's what we need to do
    @SuppressWarnings({"rawtypes", "unchecked"})
    public static BlockState copyProperties(BlockState original, BlockState copyTo) {
        for (Property prop : original.getProperties()) {
            if (copyTo.hasProperty(prop)) {
                copyTo = copyTo.setValue(prop, original.getValue(prop));
            }
        }

        return copyTo;
    }

    public static class Serializer extends RecipeSerializerBase<BrainsweepRecipe> {
        @Override
        public @NotNull BrainsweepRecipe method_8121(class_2960 recipeID, JsonObject json) {
            var blockIn = StateIngredientHelper.deserialize(class_3518.method_15296(json, "blockIn"));
            var villagerIn = VillagerIngredient.deserialize(class_3518.method_15296(json, "villagerIn"));
            var result = StateIngredientHelper.readBlockState(class_3518.method_15296(json, "result"));
            return new BrainsweepRecipe(recipeID, blockIn, villagerIn, result);
        }

        @Override
        public void toNetwork(class_2540 buf, BrainsweepRecipe recipe) {
            recipe.blockIn.write(buf);
            recipe.villagerIn.write(buf);
            buf.method_10804(class_2248.method_9507(recipe.result));
        }

        @Override
        public @NotNull BrainsweepRecipe method_8122(class_2960 recipeID, class_2540 buf) {
            var blockIn = StateIngredientHelper.read(buf);
            var villagerIn = VillagerIngredient.read(buf);
            var result = class_2248.method_9531(buf.method_10816());
            return new BrainsweepRecipe(recipeID, blockIn, villagerIn, result);
        }
    }
}
