package at.petrak.hexcasting.common.misc;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.common.lib.HexBlocks;
import com.google.common.collect.Lists;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import net.minecraft.class_2248;
import net.minecraft.class_2647;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_4643;
import net.minecraft.class_4651;
import net.minecraft.class_5204;
import net.minecraft.class_5207;
import net.minecraft.class_5212;
import net.minecraft.class_6016;
import net.minecraft.class_6803;
import net.minecraft.class_6880;

public class AkashicTreeGrower extends class_2647 {
    public static final AkashicTreeGrower INSTANCE = new AkashicTreeGrower();

    public static final List<class_6880<class_2975<class_4643, ?>>> GROWERS = Lists.newArrayList();

    static {
        GROWERS.add(buildTreeFeature(HexBlocks.AKASHIC_LEAVES1, "1"));
        GROWERS.add(buildTreeFeature(HexBlocks.AKASHIC_LEAVES2, "2"));
        GROWERS.add(buildTreeFeature(HexBlocks.AKASHIC_LEAVES3, "3"));
    }

    private static class_6880<class_2975<class_4643, ?>> buildTreeFeature(class_2248 leaves, String name) {
        return class_6803.method_39708(HexAPI.MOD_ID + ":akashic_tree" + name, class_3031.field_24134,
            new class_4643.class_4644(
                class_4651.method_38432(HexBlocks.AKASHIC_LOG),
                // baseHeight, heightRandA, heightRandB
                new class_5212(5, 5, 3),
                class_4651.method_38432(leaves),
                // radius, offset, height
                new class_5207(class_6016.method_34998(1), class_6016.method_34998(5), 5),
                // limit, lower size, upper size, minclippedheight
                new class_5204(0, 0, 0, OptionalInt.of(6))
            ).method_23445());
    }

    @Nullable
    @Override
    protected class_6880<? extends class_2975<?, ?>> method_11430(Random pRandom, boolean pLargeHive) {
        return GROWERS.get(pRandom.nextInt(GROWERS.size()));
    }
}
