package at.petrak.hexcasting.common.loot;

import at.petrak.hexcasting.api.PatternRegistry;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.common.items.ItemScroll;
import at.petrak.hexcasting.common.lib.HexLootFunctions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.class_120;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import var;

public class PatternScrollFunc extends class_120 {
    public PatternScrollFunc(class_5341[] lootItemConditions) {
        super(lootItemConditions);
    }

    @Override
    protected class_1799 method_522(class_1799 stack, class_47 ctx) {
        var rand = ctx.method_294();
        var worldLookup = PatternRegistry.getPerWorldPatterns(ctx.method_299());

        var keys = worldLookup.keySet().stream().toList();
        var sig = keys.get(rand.nextInt(keys.size()));

        var entry = worldLookup.get(sig);
        var opId = entry.component1();
        var startDir = entry.component2();
        var tag = new class_2487();
        tag.putString(ItemScroll.TAG_OP_ID, opId.toString());
        tag.put(ItemScroll.TAG_PATTERN, HexPattern.fromAngles(sig, startDir).serializeToNBT());

        stack.method_7948().method_10543(tag);

        return stack;
    }

    @Override
    public class_5339 method_29321() {
        return HexLootFunctions.PATTERN_SCROLL;
    }

    public static class Serializer extends class_120.class_123<PatternScrollFunc> {
        @Override
        public void serialize(JsonObject json, PatternScrollFunc value, JsonSerializationContext ctx) {
            super.method_529(json, value, ctx);
        }

        @Override
        public PatternScrollFunc method_530(JsonObject object, JsonDeserializationContext ctx,
            class_5341[] conditions) {
            return new PatternScrollFunc(conditions);
        }
    }
}
