package at.petrak.hexcasting.common.lib;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import var;

import static at.petrak.hexcasting.api.HexAPI.modLoc;

public class HexSounds {
    public static void registerSounds(BiConsumer<class_3414, class_2960> r) {
        for (var e : SOUNDS.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    private static final Map<class_2960, class_3414> SOUNDS = new LinkedHashMap<>();

    public static final class_3414 ADD_LINE = sound("casting.add_line");
    public static final class_3414 START_PATTERN = sound("casting.start_pattern");
    public static final class_3414 ADD_PATTERN = sound("casting.add_pattern");
    public static final class_3414 FAIL_PATTERN = sound("casting.fail_pattern");
    public static final class_3414 CASTING_AMBIANCE = sound("casting.ambiance");
    public static final class_3414 ACTUALLY_CAST = sound("casting.cast");

    public static final class_3414 ABACUS = sound("abacus");
    public static final class_3414 ABACUS_SHAKE = sound("abacus.shake");

    public static final class_3414 SPELL_CIRCLE_FIND_BLOCK = sound("spellcircle.find_block");
    public static final class_3414 SPELL_CIRCLE_FAIL = sound("spellcircle.fail");
    public static final class_3414 SPELL_CIRCLE_CAST = sound("spellcircle.cast");

    public static final class_3414 SCROLL_DUST = sound("scroll.dust");
    public static final class_3414 SCROLL_SCRIBBLE = sound("scroll.scribble");

    public static final class_3414 IMPETUS_LOOK_TICK = sound("impetus.fletcher.tick");
    public static final class_3414 IMPETUS_STOREDPLAYER_DING = sound("impetus.cleric.register");

    private static class_3414 sound(String name) {
        var id = modLoc(name);
        var sound = new class_3414(id);
        var old = SOUNDS.put(id, sound);
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + name);
        }
        return sound;
    }
}
