package at.petrak.hexcasting.common.lib;

import at.petrak.hexcasting.common.particles.ConjureParticleOptions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2960;
import var;

import static at.petrak.hexcasting.api.HexAPI.modLoc;

public class HexParticles {
    public static void registerParticles(BiConsumer<class_2396<?>, class_2960> r) {
        for (var e : PARTICLES.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    private static final Map<class_2960, class_2396<?>> PARTICLES = new LinkedHashMap<>();

    public static final ConjureParticleOptions.Type CONJURE_PARTICLE = register(
        "conjure_block_particle", new ConjureParticleOptions.Type(false));
    public static final ConjureParticleOptions.Type LIGHT_PARTICLE = register(
        "conjure_light_particle", new ConjureParticleOptions.Type(false));

    private static <O extends class_2394, T extends class_2396<O>> T register(String id, T particle) {
        var old = PARTICLES.put(modLoc(id), particle);
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + id);
        }
        return particle;
    }
}
