package at.petrak.hexcasting.common.lib;

import at.petrak.hexcasting.common.loot.AmethystReducerFunc;
import at.petrak.hexcasting.common.loot.PatternScrollFunc;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_2960;
import net.minecraft.class_5339;
import var;

import static at.petrak.hexcasting.api.HexAPI.modLoc;

public class HexLootFunctions {
    public static void registerSerializers(BiConsumer<class_5339, class_2960> r) {
        for (var e : LOOT_FUNCS.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    private static final Map<class_2960, class_5339> LOOT_FUNCS = new LinkedHashMap<>();

    public static final class_5339 PATTERN_SCROLL = register("pattern_scroll",
        new class_5339(new PatternScrollFunc.Serializer()));
    public static final class_5339 AMETHYST_SHARD_REDUCER = register("amethyst_shard_reducer",
        new class_5339(new AmethystReducerFunc.Serializer()));

    private static class_5339 register(String id, class_5339 lift) {
        var old = LOOT_FUNCS.put(modLoc(id), lift);
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + id);
        }
        return lift;
    }
}
