package at.petrak.hexcasting.common.lib;

import at.petrak.hexcasting.common.items.*;
import at.petrak.hexcasting.common.items.colorizer.ItemDyeColorizer;
import at.petrak.hexcasting.common.items.colorizer.ItemPrideColorizer;
import at.petrak.hexcasting.common.items.colorizer.ItemUUIDColorizer;
import at.petrak.hexcasting.common.items.magic.*;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import net.minecraft.class_1304;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1834;
import net.minecraft.class_2960;
import net.minecraft.class_4174;
import net.minecraft.world.item.*;
import var;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;

import static at.petrak.hexcasting.api.HexAPI.modLoc;

// https://github.com/VazkiiMods/Botania/blob/2c4f7fdf9ebf0c0afa1406dfe1322841133d75fa/Common/src/main/java/vazkii/botania/common/item/ModItems.java
public class HexItems {
    public static void registerItems(BiConsumer<class_1792, class_2960> r) {
        for (var e : ITEMS.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    private static final Map<class_2960, class_1792> ITEMS = new LinkedHashMap<>(); // preserve insertion order

    public static final class_1792 AMETHYST_DUST = make("amethyst_dust", new class_1792(props()));
    public static final class_1792 CHARGED_AMETHYST = make("charged_amethyst", new class_1792(props()));

    public static final ItemWand WAND_OAK = make("wand_oak", new ItemWand(unstackable()));
    public static final ItemWand WAND_SPRUCE = make("wand_spruce", new ItemWand(unstackable()));
    public static final ItemWand WAND_BIRCH = make("wand_birch", new ItemWand(unstackable()));
    public static final ItemWand WAND_JUNGLE = make("wand_jungle", new ItemWand(unstackable()));
    public static final ItemWand WAND_ACACIA = make("wand_acacia", new ItemWand(unstackable()));
    public static final ItemWand WAND_DARK_OAK = make("wand_dark_oak", new ItemWand(unstackable()));
    public static final ItemWand WAND_CRIMSON = make("wand_crimson", new ItemWand(unstackable()));
    public static final ItemWand WAND_WARPED = make("wand_warped", new ItemWand(unstackable()));
    public static final ItemWand WAND_AKASHIC = make("wand_akashic", new ItemWand(unstackable()));

    public static final ItemLens SCRYING_LENS = make("lens", new ItemLens(
        IXplatAbstractions.INSTANCE.addEquipSlotFabric(class_1304.field_6169)
            .method_7889(1)
            .method_7892(IXplatAbstractions.INSTANCE.getTab())));

    public static final ItemAbacus ABACUS = make("abacus", new ItemAbacus(unstackable()));
    public static final ItemFocus FOCUS = make("focus", new ItemFocus(unstackable()));
    public static final ItemSpellbook SPELLBOOK = make("spellbook", new ItemSpellbook(unstackable()));

    public static final ItemCypher CYPHER = make("cypher", new ItemCypher(unstackable()));
    public static final ItemTrinket TRINKET = make("trinket", new ItemTrinket(unstackable()));
    public static final ItemArtifact ARTIFACT = make("artifact", new ItemArtifact(unstackable()));

    public static final ItemJewelerHammer JEWELER_HAMMER = make("jeweler_hammer",
        new ItemJewelerHammer(class_1834.field_8923, 0, -2.8F, props().method_7889(1).method_7898(class_1834.field_8930.method_8025())));

    public static final ItemScroll SCROLL = make("scroll", new ItemScroll(props()));

    public static final ItemSlate SLATE = make("slate", new ItemSlate(HexBlocks.SLATE, props()));

    public static final ItemManaBattery BATTERY = make("battery",
        new ItemManaBattery(new class_1792.class_1793().method_7889(1)));

    public static final EnumMap<class_1767, ItemDyeColorizer> DYE_COLORIZERS = new EnumMap<>(
        class_1767.class);
    public static final ItemPrideColorizer[] PRIDE_COLORIZERS = new ItemPrideColorizer[14];

    static {
        for (var dye : class_1767.values()) {
            DYE_COLORIZERS.put(dye, make("dye_colorizer_" + dye.getName(), new ItemDyeColorizer(dye, unstackable())));
        }
        for (int i = 0; i < PRIDE_COLORIZERS.length; i++) {
            PRIDE_COLORIZERS[i] = make("pride_colorizer_" + i, new ItemPrideColorizer(i, unstackable()));
        }
    }

    public static final class_1792 UUID_COLORIZER = make("uuid_colorizer", new ItemUUIDColorizer(unstackable()));

    // BUFF SANDVICH
    public static final class_1792 SUBMARINE_SANDWICH = make("sub_sandwich",
        new class_1792(props().method_19265(new class_4174.class_4175().method_19238(14).method_19237(1.2f).method_19242())));

    public static final ItemCreativeUnlocker CREATIVE_UNLOCKER = make("creative_unlocker",
        new ItemCreativeUnlocker(unstackable()
                .method_7894(class_1814.field_8904)
                .method_19265(new class_4174.class_4175().method_19238(20).method_19237(1f).method_19240().method_19242())));

    //

    public static class_1792.class_1793 props() {
        return new class_1792.class_1793().method_7892(IXplatAbstractions.INSTANCE.getTab());
    }

    public static class_1792.class_1793 unstackable() {
        return props().method_7889(1);
    }

    private static <T extends class_1792> T make(class_2960 id, T item) {
        var old = ITEMS.put(id, item);
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + id);
        }
        return item;
    }

    private static <T extends class_1792> T make(String id, T item) {
        return make(modLoc(id), item);
    }

    public static class_1799 tabIcon() {
        return new class_1799(SPELLBOOK);
    }
}
