package at.petrak.hexcasting.common.lib;

import at.petrak.hexcasting.api.block.circle.BlockAbstractImpetus;
import at.petrak.hexcasting.api.spell.DatumType;
import at.petrak.hexcasting.common.blocks.BlockConjured;
import at.petrak.hexcasting.common.blocks.BlockConjuredLight;
import at.petrak.hexcasting.common.blocks.BlockFlammable;
import at.petrak.hexcasting.common.blocks.akashic.*;
import at.petrak.hexcasting.common.blocks.circles.BlockEmptyImpetus;
import at.petrak.hexcasting.common.blocks.circles.BlockSlate;
import at.petrak.hexcasting.common.blocks.circles.directrix.BlockEmptyDirectrix;
import at.petrak.hexcasting.common.blocks.circles.directrix.BlockRedstoneDirectrix;
import at.petrak.hexcasting.common.blocks.circles.impetuses.BlockLookingImpetus;
import at.petrak.hexcasting.common.blocks.circles.impetuses.BlockRightClickImpetus;
import at.petrak.hexcasting.common.blocks.circles.impetuses.BlockStoredPlayerImpetus;
import at.petrak.hexcasting.common.blocks.decoration.*;
import com.mojang.datafixers.util.Pair;
import net.minecraft.class_1299;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2440;
import net.minecraft.class_2468;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2571;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_5541;
import net.minecraft.world.level.block.*;
import var;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;

import static at.petrak.hexcasting.api.HexAPI.modLoc;

public class HexBlocks {
    public static void registerBlocks(BiConsumer<class_2248, class_2960> r) {
        for (var e : BLOCKS.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    public static void registerBlockItems(BiConsumer<class_1792, class_2960> r) {
        for (var e : BLOCK_ITEMS.entrySet()) {
            r.accept(new class_1747(e.getValue().getFirst(), e.getValue().getSecond()), e.getKey());
        }
    }

    private static final Map<class_2960, class_2248> BLOCKS = new LinkedHashMap<>();
    private static final Map<class_2960, Pair<class_2248, class_1792.class_1793>> BLOCK_ITEMS = new LinkedHashMap<>();

    private static class_4970.class_2251 slateish() {
        return class_4970.class_2251
            .method_9639(class_3614.field_15914, class_3620.field_33532)
            .method_9626(class_2498.field_29035)
            .method_9629(4f, 4f);
    }

    private static class_4970.class_2251 papery(class_3620 color) {
        return class_4970.class_2251
            .method_9639(class_3614.field_15935, color)
            .method_9626(class_2498.field_11535)
            .method_9618();
    }

    private static class_4970.class_2251 akashicWoodyHard() {
        return woodyHard(class_3620.field_16014);
    }

    private static class_4970.class_2251 woodyHard(class_3620 color) {
        return class_4970.class_2251.method_9639(class_3614.field_15932, color)
            .method_9626(class_2498.field_11547)
            .method_9629(3f, 4f);
    }

    private static class_4970.class_2251 akashicWoody() {
        return woody(class_3620.field_16014);
    }

    private static class_4970.class_2251 woody(class_3620 color) {
        return class_4970.class_2251.method_9639(class_3614.field_15932, color)
            .method_9626(class_2498.field_11547)
            .method_9632(2f);
    }

    private static class_4970.class_2251 leaves(class_3620 color) {
        return class_4970.class_2251.method_9639(class_3614.field_15923, color)
            .method_9632(0.2F)
            .method_9640()
            .method_9626(class_2498.field_11535)
            .method_22488()
            .method_26235((bs, level, pos, type) -> type == class_1299.field_6081 || type == class_1299.field_6104)
            .method_26243(HexBlocks::never)
            .method_26245(HexBlocks::never);
    }

    // we give these faux items so Patchi can have an item to view with
    public static final class_2248 CONJURED_LIGHT = blockItem("conjured",
        new BlockConjuredLight(
            class_4970.class_2251.method_9639(class_3614.field_15942, class_3620.field_16008)
                .method_9626(class_2498.field_27197)
                .method_9631((state) -> 15)
                .method_16229()
                .method_26235(HexBlocks::never)
                .method_9618()
                .method_9634()
                .method_26243(HexBlocks::never)
                .method_26245(HexBlocks::never)),
        new class_1792.class_1793());
    public static final class_2248 CONJURED_BLOCK = blockItem("conjured_block",
        new BlockConjured(
            class_4970.class_2251.method_9639(class_3614.field_15942, class_3620.field_16008)
                .method_9626(class_2498.field_27197)
                .method_9631((state) -> 2)
                .method_16229()
                .method_26235(HexBlocks::never)
                .method_9618()
                .method_22488()
                .method_26243(HexBlocks::never)
                .method_26245(HexBlocks::never)),
        new class_1792.class_1793());

    // "no" item because we add it manually
    public static final BlockSlate SLATE = blockNoItem("slate", new BlockSlate(slateish()));

    public static final BlockEmptyImpetus EMPTY_IMPETUS = blockItem("empty_impetus", new BlockEmptyImpetus(slateish()));
    public static final BlockRightClickImpetus IMPETUS_RIGHTCLICK = blockItem("impetus_rightclick",
        new BlockRightClickImpetus(slateish()
            .method_9631(bs -> bs.method_11654(BlockAbstractImpetus.ENERGIZED) ? 15 : 0)));
    public static final BlockLookingImpetus IMPETUS_LOOK = blockItem("impetus_look",
        new BlockLookingImpetus(slateish()
            .method_9631(bs -> bs.method_11654(BlockAbstractImpetus.ENERGIZED) ? 15 : 0)));
    public static final BlockStoredPlayerImpetus IMPETUS_STOREDPLAYER = blockItem("impetus_storedplayer",
        new BlockStoredPlayerImpetus(slateish()
            .method_9631(bs -> bs.method_11654(BlockAbstractImpetus.ENERGIZED) ? 15 : 0)));


    public static final BlockEmptyDirectrix EMPTY_DIRECTRIX = blockItem("empty_directrix",
        new BlockEmptyDirectrix(slateish()));
    public static final BlockRedstoneDirectrix DIRECTRIX_REDSTONE = blockItem("directrix_redstone",
        new BlockRedstoneDirectrix(slateish()));

    public static final BlockAkashicRecord AKASHIC_RECORD = blockItem("akashic_record",
        new BlockAkashicRecord(akashicWoodyHard().method_9631(bs -> 15)));
    public static final BlockAkashicBookshelf AKASHIC_BOOKSHELF = blockItem("akashic_bookshelf",
        new BlockAkashicBookshelf(akashicWoodyHard()
            .method_9631(bs -> (bs.method_11654(BlockAkashicBookshelf.DATUM_TYPE) == DatumType.EMPTY) ? 0 : 4)));
    public static final BlockAkashicFloodfiller AKASHIC_CONNECTOR = blockItem("akashic_connector",
        new BlockAkashicFloodfiller(akashicWoodyHard().method_9631(bs -> 10)));

    // Decoration?!
    public static final class_2248 SLATE_BLOCK = blockItem("slate_block", new class_2248(slateish().method_9629(2f, 4f)));
    public static final class_2468 AMETHYST_DUST_BLOCK = blockItem("amethyst_dust_block",
        new class_2468(0xff_b38ef3, class_4970.class_2251.method_9639(class_3614.field_15916, class_3620.field_16014)
            .method_9632(0.5f).method_9626(class_2498.field_11526)));
    public static final class_5541 AMETHYST_TILES = blockItem("amethyst_tiles",
        new class_5541(class_4970.class_2251.method_9630(class_2246.field_27159)));
    public static final class_2248 SCROLL_PAPER = blockItem("scroll_paper",
        new BlockFlammable(papery(class_3620.field_16003), 100, 60));
    public static final class_2248 ANCIENT_SCROLL_PAPER = blockItem("ancient_scroll_paper",
        new BlockFlammable(papery(class_3620.field_15981), 100, 60));
    public static final class_2248 SCROLL_PAPER_LANTERN = blockItem("scroll_paper_lantern",
        new BlockFlammable(papery(class_3620.field_16003).method_9631($ -> 15), 100, 60));
    public static final class_2248 ANCIENT_SCROLL_PAPER_LANTERN = blockItem(
        "ancient_scroll_paper_lantern",
        new BlockFlammable(papery(class_3620.field_15981).method_9631($ -> 12), 100, 60));
    public static final BlockSconce SCONCE = blockItem("amethyst_sconce",
        new BlockSconce(class_4970.class_2251.method_9639(class_3614.field_27340, class_3620.field_16014)
            .method_9626(class_2498.field_27197)
            .method_9632(1f)
            .method_9631($ -> 15)));

    public static final BlockAxis AKASHIC_LOG = blockItem("akashic_log",
        new BlockAkashicLog(akashicWoody()));
    public static final BlockAxis AKASHIC_LOG_STRIPPED = blockItem("akashic_log_stripped",
        new BlockAkashicLog(akashicWoody()));
    public static final class_2248 AKASHIC_WOOD = blockItem("akashic_wood",
        new BlockFlammable(akashicWoody(), 5, 5));
    public static final class_2248 AKASHIC_WOOD_STRIPPED = blockItem("akashic_wood_stripped",
        new BlockFlammable(akashicWoody(), 5, 5));
    public static final class_2248 AKASHIC_PLANKS = blockItem("akashic_planks",
        new BlockFlammable(akashicWoody(), 20, 5));
    public static final class_2248 AKASHIC_PANEL = blockItem("akashic_panel",
        new BlockFlammable(akashicWoody(), 20, 5));
    public static final class_2248 AKASHIC_TILE = blockItem("akashic_tile",
        new BlockFlammable(akashicWoody(), 20, 5));
    public static final class_2323 AKASHIC_DOOR = blockItem("akashic_door",
        new BlockHexDoor(akashicWoody().method_22488()));
    public static final class_2533 AKASHIC_TRAPDOOR = blockItem("akashic_trapdoor",
        new BlockHexTrapdoor(akashicWoody().method_22488()));
    public static final class_2510 AKASHIC_STAIRS = blockItem("akashic_stairs",
        new BlockHexStairs(AKASHIC_PLANKS.method_9564(), akashicWoody().method_22488()));
    public static final class_2482 AKASHIC_SLAB = blockItem("akashic_slab",
        new BlockHexSlab(akashicWoody().method_22488()));
    public static final class_2571 AKASHIC_BUTTON = blockItem("akashic_button",
        new BlockHexWoodButton(akashicWoody().method_22488()));
    public static final class_2440 AKASHIC_PRESSURE_PLATE = blockItem("akashic_pressure_plate",
        new BlockHexPressurePlate(class_2440.class_2441.field_11361, akashicWoody().method_22488()));
    public static final BlockAkashicLeaves AKASHIC_LEAVES1 = blockItem("akashic_leaves1",
        new BlockAkashicLeaves(leaves(class_3620.field_16014)));
    public static final BlockAkashicLeaves AKASHIC_LEAVES2 = blockItem("akashic_leaves2",
        new BlockAkashicLeaves(leaves(class_3620.field_15984)));
    public static final BlockAkashicLeaves AKASHIC_LEAVES3 = blockItem("akashic_leaves3",
        new BlockAkashicLeaves(leaves(class_3620.field_16010)));

    private static boolean never(Object... args) {
        return false;
    }

    private static <T extends class_2248> T blockNoItem(String name, T block) {
        var old = BLOCKS.put(modLoc(name), block);
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + name);
        }
        return block;
    }

    private static <T extends class_2248> T blockItem(String name, T block) {
        return blockItem(name, block, HexItems.props());
    }

    private static <T extends class_2248> T blockItem(String name, T block, class_1792.class_1793 props) {
        blockNoItem(name, block);
        var old = BLOCK_ITEMS.put(modLoc(name), new Pair<>(block, props));
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + name);
        }
        return block;
    }
}


