package at.petrak.hexcasting.common.lib;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicBookshelf;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicRecord;
import at.petrak.hexcasting.common.blocks.circles.BlockEntitySlate;
import at.petrak.hexcasting.common.blocks.entity.BlockEntityConjured;
import at.petrak.hexcasting.common.blocks.entity.BlockEntityLookingImpetus;
import at.petrak.hexcasting.common.blocks.entity.BlockEntityRightClickImpetus;
import at.petrak.hexcasting.common.blocks.entity.BlockEntityStoredPlayerImpetus;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import var;

public class HexBlockEntities {
    public static void registerTiles(BiConsumer<class_2591<?>, class_2960> r) {
        for (var e : BLOCK_ENTITIES.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    private static final Map<class_2960, class_2591<?>> BLOCK_ENTITIES = new LinkedHashMap<>();

    public static final class_2591<BlockEntityConjured> CONJURED_TILE = register(
        "conjured_tile",
        BlockEntityConjured::new, HexBlocks.CONJURED_LIGHT, HexBlocks.CONJURED_BLOCK);

    public static final class_2591<BlockEntityAkashicBookshelf> AKASHIC_BOOKSHELF_TILE = register(
        "akashic_bookshelf_tile",
        BlockEntityAkashicBookshelf::new, HexBlocks.AKASHIC_BOOKSHELF);
    public static final class_2591<BlockEntityAkashicRecord> AKASHIC_RECORD_TILE = register(
        "akashic_record_tile",
        BlockEntityAkashicRecord::new, HexBlocks.AKASHIC_RECORD);

    public static final class_2591<BlockEntityStoredPlayerImpetus> IMPETUS_STOREDPLAYER_TILE = register(
        "impetus_storedplayer_tile",
        BlockEntityStoredPlayerImpetus::new, HexBlocks.IMPETUS_STOREDPLAYER);
    public static final class_2591<BlockEntityLookingImpetus> IMPETUS_LOOK_TILE = register(
        "impetus_look_tile",
        BlockEntityLookingImpetus::new, HexBlocks.IMPETUS_LOOK);
    public static final class_2591<BlockEntityRightClickImpetus> IMPETUS_RIGHTCLICK_TILE = register(
        "impetus_rightclick_tile",
        BlockEntityRightClickImpetus::new, HexBlocks.IMPETUS_RIGHTCLICK);

    public static final class_2591<BlockEntitySlate> SLATE_TILE = register(
        "slate_tile",
        BlockEntitySlate::new, HexBlocks.SLATE);

    private static <T extends class_2586> class_2591<T> register(String id,
        BiFunction<class_2338, class_2680, T> func, class_2248... blocks) {
        var ret = IXplatAbstractions.INSTANCE.createBlockEntityType(func, blocks);
        var old = BLOCK_ENTITIES.put(new class_2960(HexAPI.MOD_ID, id), ret);
        if (old != null) {
            throw new IllegalArgumentException("Duplicate id " + id);
        }
        return ret;
    }

}
