package at.petrak.hexcasting.common.items.magic;

import at.petrak.hexcasting.api.item.HexHolderItem;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.CastingHarness;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.lib.HexSounds;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3445;
import net.minecraft.class_3468;

import static at.petrak.hexcasting.api.HexAPI.modLoc;

/**
 * Item that holds a list of patterns in it ready to be cast
 */
public abstract class ItemPackagedHex extends ItemManaHolder implements HexHolderItem {
    public static final String TAG_PATTERNS = "patterns";
    public static final class_2960 HAS_PATTERNS_PRED = modLoc("has_patterns");

    public ItemPackagedHex(class_1793 pProperties) {
        super(pProperties);
    }

    public abstract boolean breakAfterDepletion();

    @Override
    public boolean canRecharge(class_1799 stack) {
        return !breakAfterDepletion();
    }

    @Override
    public boolean manaProvider(class_1799 stack) {
        return false;
    }

    @Override
    public boolean hasHex(class_1799 stack) {
        return NBTHelper.hasList(stack, TAG_PATTERNS, class_2520.field_33260);
    }

    @Override
    public @Nullable List<SpellDatum<?>> getHex(class_1799 stack, class_3218 level) {
        var patsTag = NBTHelper.getList(stack, TAG_PATTERNS, class_2520.field_33260);

        if (patsTag == null) {
            return null;
        }

        var out = new ArrayList<SpellDatum<?>>();
        for (var patTag : patsTag) {
            class_2487 tag = NBTHelper.getAsCompound(patTag);
            if (tag.method_10546() != 1) {
                out.add(SpellDatum.make(HexPattern.fromNBT(tag)));
            } else {
                out.add(SpellDatum.fromNBT(tag, level));
            }
        }
        return out;
    }

    @Override
    public void writeHex(class_1799 stack, List<SpellDatum<?>> patterns, int mana) {
        class_2499 patsTag = new class_2499();
        for (SpellDatum<?> pat : patterns) {
            patsTag.add(pat.serializeToNBT());
        }

        NBTHelper.putList(stack, TAG_PATTERNS, patsTag);

        withMana(stack, mana, mana);
    }

    @Override
    public void clearHex(class_1799 stack) {
        NBTHelper.remove(stack, ItemPackagedHex.TAG_PATTERNS);
        NBTHelper.remove(stack, TAG_MANA);
        NBTHelper.remove(stack, TAG_MAX_MANA);
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 usedHand) {
        var stack = player.method_5998(usedHand);
        if (!hasHex(stack)) {
            return class_1271.method_22431(stack);
        }

        if (world.field_9236) {
            return class_1271.method_22427(stack);
        }

        List<SpellDatum<?>> instrs = getHex(stack, (class_3218) world);
        if (instrs == null) {
            return class_1271.method_22431(stack);
        }
        var sPlayer = (class_3222) player;
        var ctx = new CastingContext(sPlayer, usedHand);
        var harness = new CastingHarness(ctx);
        var info = harness.executeIotas(instrs, sPlayer.getLevel());

        boolean broken = breakAfterDepletion() && getMana(stack) == 0;

        class_3445<?> stat;
        if (broken) {
            stat = class_3468.field_15383.method_14956(this);
        } else {
            stat = class_3468.field_15372.method_14956(this);
        }
        player.method_7259(stat);

        sPlayer.getCooldowns().addCooldown(this, 5);
        sPlayer.level.playSound(null, sPlayer.getX(), sPlayer.getY(), sPlayer.getZ(),
            HexSounds.ACTUALLY_CAST, class_3419.field_15248, 1f,
            1f + ((float) Math.random() - 0.5f) * 0.2f);

        if (broken) {
            stack.shrink(1);
            player.method_20236(usedHand);
            return class_1271.method_22428(stack);
        } else {
            return class_1271.method_22427(stack);
        }
    }

    @Override
    public int method_7881(class_1799 pStack) {
        return 16;
    }

    @Override
    public class_1839 method_7853(class_1799 pStack) {
        return class_1839.field_8949;
    }
}
