package at.petrak.hexcasting.common.items.magic;

import at.petrak.hexcasting.api.item.ManaHolderItem;
import at.petrak.hexcasting.api.utils.ManaHelper;
import at.petrak.hexcasting.api.utils.NBTHelper;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3532;

public abstract class ItemManaHolder extends class_1792 implements ManaHolderItem {
    public static final String TAG_MANA = "hexcasting:mana";
    public static final String TAG_MAX_MANA = "hexcasting:start_mana";

    public ItemManaHolder(class_1793 pProperties) {
        super(pProperties);
    }

    public static class_1799 withMana(class_1799 stack, int mana, int maxMana) {
        class_1792 item = stack.method_7909();
        if (item instanceof ItemManaHolder) {
            NBTHelper.putInt(stack, TAG_MANA, mana);
            NBTHelper.putInt(stack, TAG_MAX_MANA, maxMana);
        }

        return stack;
    }

    @Override
    public int getMana(class_1799 stack) {
        return NBTHelper.getInt(stack, TAG_MANA);
    }

    @Override
    public int getMaxMana(class_1799 stack) {
        return NBTHelper.getInt(stack, TAG_MAX_MANA);
    }

    @Override
    public void setMana(class_1799 stack, int mana) {
        NBTHelper.putInt(stack, TAG_MANA, class_3532.method_15340(mana, 0, getMaxMana(stack)));
    }

    @Override
    public boolean method_31567(class_1799 pStack) {
        return getMaxMana(pStack) > 0;
    }

    @Override
    public int method_31571(class_1799 pStack) {
        var mana = getMana(pStack);
        var maxMana = getMaxMana(pStack);
        return ManaHelper.manaBarColor(mana, maxMana);
    }

    @Override
    public int method_31569(class_1799 pStack) {
        var mana = getMana(pStack);
        var maxMana = getMaxMana(pStack);
        return ManaHelper.manaBarWidth(mana, maxMana);
    }

    @Override
    public boolean method_7846() {
        return false;
    }

    @Override
    public void method_7851(class_1799 pStack, @Nullable class_1937 pLevel, List<class_2561> pTooltipComponents,
        class_1836 pIsAdvanced) {
        if (pIsAdvanced.method_8035() && getMaxMana(pStack) > 0) {
            pTooltipComponents.add(
                new class_2588("item.hexcasting.manaholder.amount",
                    String.format("%,d", getMana(pStack)),
                    String.format("%,d", getMaxMana(pStack)),
                    100f * getManaFullness(pStack)).method_27692(class_124.field_1080));
        }

        super.method_7851(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}
