package at.petrak.hexcasting.common.items.colorizer;

import at.petrak.hexcasting.api.addldata.Colorizer;
import at.petrak.hexcasting.api.item.ColorizerItem;
import at.petrak.paucal.api.PaucalAPI;
import java.awt.*;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import var;

public class ItemUUIDColorizer extends class_1792 implements ColorizerItem {
    public ItemUUIDColorizer(class_1793 pProperties) {
        super(pProperties);
    }

    @Override
    public int color(class_1799 stack, UUID owner, float time, class_243 position) {
        var contributor = PaucalAPI.instance().getContributor(owner);
        if (contributor != null) {
            List<?> colorList = contributor.get("hexcasting:colorizer");
            if (colorList != null) {
                var colors = new int[colorList.size()];
                var ok = true;
                for (int i = 0; i < colorList.size(); i++) {
                    Object elt = colorList.get(i);
                    if (elt instanceof Number n) {
                        colors[i] = n.intValue() | 0xff_000000;
                    } else {
                        ok = false;
                        break;
                    }
                }
                if (ok) {
                    return Colorizer.morphBetweenColors(colors, new class_243(0.1, 0.1, 0.1), time / 20 / 20, position);
                }
            }
        }

        // randomly scrungle the bits
        var rand = new Random(owner.getLeastSignificantBits() ^ owner.getMostSignificantBits());
        var hue = rand.nextFloat();
        var saturation = rand.nextFloat(0.4f, 1.0f);
        var brightness = rand.nextFloat(0.5f, 1.0f);

        return Color.HSBtoRGB(hue, saturation, brightness);
    }
}
