package at.petrak.hexcasting.common.items.colorizer;

import at.petrak.hexcasting.api.addldata.Colorizer;
import at.petrak.hexcasting.api.item.ColorizerItem;
import java.util.UUID;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_243;

public class ItemPrideColorizer extends class_1792 implements ColorizerItem {
    private final int idx;

    public ItemPrideColorizer(int idx, class_1793 pProperties) {
        super(pProperties);
        this.idx = idx;
    }

    @Override
    public int color(class_1799 stack, UUID owner, float time, class_243 position) {
        return Colorizer.morphBetweenColors(getColors(), new class_243(0.1, 0.1, 0.1), time / 20 / 20, position);
    }

    public int[] getColors() {
        return COLORS[this.idx];
    }

    private static final int[][] COLORS;

    static {
        COLORS = new int[][]{
            {0xeb92ea, 0xffffff, 0x6ac2e4},
            {0xd82f3a, 0xe0883f, 0xebf367, 0x2db418, 0x2f4dd8},
            {0x16a10c, 0x82eb8b, 0xffffff, 0x7a8081},
            {0x333233, 0x9a9fa1, 0xffffff, 0x7210bc},
            {0xdb45ff, 0x9c2bd0, 0x6894d4},
            {0xe278ef, 0xebf367, 0x6ac2e4},
            {0xca78ef, 0xffffff, 0x2db418},
            {0x9a9fa1, 0xfcb1ff, 0xffffff},
            {0xebf367, 0xffffff, 0x7210bc, 0x333233},
            {0xd82f3a, 0xefb87d, 0xffffff, 0xfbacf9},
            {0x9a9fa1, 0xa9ffff, 0xffffff},
            {0xfbacf9, 0xffffff, 0x9c2bd0, 0x333233, 0x2f4dd8},
            {0xebf367, 0x7210bc}, // how to do an intersex gradient escapes me
            {0x7210bc, 0xebf367, 0xffffff, 0x82dceb, 0x2f4dd8}
        };
        for (int[] color : COLORS) {
            for (int i = 0; i < color.length; i++) {
                color[i] |= 0xff_000000;
            }
        }
    }
}
