package at.petrak.hexcasting.common.items;

import at.petrak.hexcasting.api.item.DataHolderItem;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.Widget;
import at.petrak.hexcasting.api.utils.NBTHelper;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;

public class ItemSpellbook extends class_1792 implements DataHolderItem {
    public static String TAG_SELECTED_PAGE = "page_idx";
    // this is a CompoundTag of string numerical keys to SpellData
    // it is 1-indexed, so that 0/0 can be the special case of "it is empty"
    public static String TAG_PAGES = "pages";

    // this stores the names of pages, to be restored when you scroll
    // it is 1-indexed, and the 0-case for TAG_PAGES will be treated as 1
    public static String TAG_PAGE_NAMES = "page_names";

    // this stores the sealed status of each page, to be restored when you scroll
    // it is 1-indexed, and the 0-case for TAG_PAGES will be treated as 1
    public static String TAG_SEALED = "sealed_pages";

    public ItemSpellbook(class_1793 properties) {
        super(properties);
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltip,
        class_1836 isAdvanced) {
        boolean sealed = IsSealed(stack);
        boolean empty = false;
        if (NBTHelper.hasNumber(stack, TAG_SELECTED_PAGE)) {
            var pageIdx = NBTHelper.getInt(stack, TAG_SELECTED_PAGE);
            int highest = HighestPage(stack);
            if (highest != 0) {
                if (sealed)
                    tooltip.add(new class_2588("hexcasting.tooltip.spellbook.page.sealed",
                        new class_2585(String.valueOf(pageIdx)).method_27692(class_124.field_1068),
                        new class_2585(String.valueOf(highest)).method_27692(class_124.field_1068),
                        new class_2588("hexcasting.tooltip.spellbook.sealed").method_27692(class_124.field_1065))
                        .method_27692(class_124.field_1080));
                else
                    tooltip.add(new class_2588("hexcasting.tooltip.spellbook.page",
                        new class_2585(String.valueOf(pageIdx)).method_27692(class_124.field_1068),
                        new class_2585(String.valueOf(highest)).method_27692(class_124.field_1068))
                        .method_27692(class_124.field_1080));
            } else {
                empty = true;
            }
        } else {
            empty = true;
        }

        if (empty) {
            boolean overridden = NBTHelper.hasString(stack, TAG_OVERRIDE_VISUALLY);
            if (sealed) {
                if (overridden) {
                    tooltip.add(new class_2588("hexcasting.tooltip.spellbook.sealed").method_27692(class_124.field_1065));
                } else {
                    tooltip.add(new class_2588("hexcasting.tooltip.spellbook.empty.sealed",
                        new class_2588("hexcasting.tooltip.spellbook.sealed").method_27692(class_124.field_1065))
                        .method_27692(class_124.field_1080));
                }
            } else if (!overridden)
                tooltip.add(new class_2588("hexcasting.tooltip.spellbook.empty").method_27692(class_124.field_1080));
        }

        DataHolderItem.appendHoverText(this, stack, tooltip, isAdvanced);

        super.method_7851(stack, level, tooltip, isAdvanced);
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 pLevel, class_1297 pEntity, int pSlotId, boolean pIsSelected) {
        int index = GetPage(stack, 0);
        NBTHelper.putInt(stack, TAG_SELECTED_PAGE, index);

        int shiftedIdx = Math.max(1, index);
        String nameKey = String.valueOf(shiftedIdx);
        class_2487 names = NBTHelper.getOrCreateCompound(stack, TAG_PAGE_NAMES);
        if (stack.method_7938()) {
            names.method_10582(nameKey, class_2561.class_2562.method_10867(stack.method_7964()));
        } else {
            names.method_10551(nameKey);
        }
    }

    public static boolean ArePagesEmpty(class_1799 stack) {
        class_2487 tag = NBTHelper.getCompound(stack, TAG_PAGES);
        return tag == null || tag.method_33133();
    }

    @Override
    public @Nullable class_2487 readDatumTag(class_1799 stack) {
        int idx = GetPage(stack, 1);
        var key = String.valueOf(idx);
        var tag = NBTHelper.getCompound(stack, TAG_PAGES);
        if (tag != null && tag.contains(key, class_2520.field_33260)) {
            return tag.getCompound(key);
        } else {
            return null;
        }
    }

    @Override
    public @Nullable SpellDatum<?> emptyDatum(class_1799 stack) {
        return SpellDatum.make(Widget.NULL);
    }

    @Override
    public boolean canWrite(class_1799 stack, SpellDatum<?> datum) {
        return datum == null || !IsSealed(stack);
    }

    @Override
    public void writeDatum(class_1799 stack, SpellDatum<?> datum) {
        if (datum != null && IsSealed(stack))
            return;

        int idx = GetPage(stack, 1);
        var key = String.valueOf(idx);
        class_2487 pages = NBTHelper.getCompound(stack, TAG_PAGES);
        if (pages != null) {
            if (datum == null) {
                pages.method_10551(key);
                NBTHelper.remove(NBTHelper.getCompound(stack, TAG_SEALED), key);
            } else
                pages.method_10566(key, datum.serializeToNBT());

            if (pages.method_33133())
                NBTHelper.remove(stack, TAG_PAGES);
        } else if (datum != null) {
            NBTHelper.getOrCreateCompound(stack, TAG_PAGES).method_10566(key, datum.serializeToNBT());
        } else {
            NBTHelper.remove(NBTHelper.getCompound(stack, TAG_SEALED), key);
        }
    }

    public static int GetPage(class_1799 stack, int ifEmpty) {
        if (ArePagesEmpty(stack))
            return ifEmpty;
        else if (NBTHelper.hasNumber(stack, TAG_SELECTED_PAGE)) {
            int index = NBTHelper.getInt(stack, TAG_SELECTED_PAGE);
            if (index == 0) index = 1;
            return index;
        } else {
            return 1;
        }
    }

    public static void SetSealed(class_1799 stack, boolean sealed) {
        int index = GetPage(stack, 1);

        String nameKey = String.valueOf(index);
        class_2487 names = NBTHelper.getOrCreateCompound(stack, TAG_SEALED);

        if (!sealed)
            names.method_10551(nameKey);
        else
            names.method_10556(nameKey, true);

        if (names.method_33133())
            NBTHelper.remove(stack, TAG_SEALED);
        else
            NBTHelper.putCompound(stack, TAG_SEALED, names);

    }

    public static boolean IsSealed(class_1799 stack) {
        int index = GetPage(stack, 1);

        String nameKey = String.valueOf(index);
        class_2487 names = NBTHelper.getCompound(stack, TAG_SEALED);
        return NBTHelper.getBoolean(names, nameKey);
    }

    public static int HighestPage(class_1799 stack) {
        class_2487 tag = NBTHelper.getCompound(stack, TAG_PAGES);
        if (tag == null)
            return 0;
        return tag.method_10541().stream().flatMap(s -> {
            try {
                return Stream.of(Integer.parseInt(s));
            } catch (NumberFormatException e) {
                return Stream.empty();
            }
        }).max(Integer::compare).orElse(0);
    }

    public static int RotatePageIdx(class_1799 stack, boolean increase) {
        int idx = GetPage(stack, 0);
        if (idx != 0) {
            idx += increase ? 1 : -1;
            idx = Math.max(1, idx);
        }
        NBTHelper.putInt(stack, TAG_SELECTED_PAGE, idx);

        class_2487 names = NBTHelper.getCompound(stack, TAG_PAGE_NAMES);
        int shiftedIdx = Math.max(1, idx);
        String nameKey = String.valueOf(shiftedIdx);
        String name = NBTHelper.getString(names, nameKey);
        if (name != null) {
            stack.method_7977(class_2561.class_2562.method_10877(name));
        } else {
            stack.method_7925();
        }

        return idx;
    }
}
