package at.petrak.hexcasting.common.items;

import at.petrak.hexcasting.annotations.SoftImplement;
import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.item.DataHolderItem;
import at.petrak.hexcasting.api.spell.DatumType;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.client.gui.PatternTooltipGreeble;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.blocks.circles.BlockEntitySlate;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_5632;

import static at.petrak.hexcasting.api.HexAPI.modLoc;

public class ItemSlate extends class_1747 implements DataHolderItem {
    public static final class_2960 WRITTEN_PRED = modLoc("written");

    public ItemSlate(class_2248 pBlock, class_1793 pProperties) {
        super(pBlock, pProperties);
    }

    @Override
    public class_2561 method_7864(class_1799 pStack) {
        var key = "block." + HexAPI.MOD_ID + ".slate." + (hasPattern(pStack) ? "written" : "blank");
        return new class_2588(key);
    }

    public static boolean hasPattern(class_1799 stack) {
        var bet = NBTHelper.getCompound(stack, "BlockEntityTag");
        if (bet != null) {
            return bet.contains(BlockEntitySlate.TAG_PATTERN, class_2520.field_33260) &&
                !bet.getCompound(BlockEntitySlate.TAG_PATTERN).isEmpty();
        }
        return false;
    }

    @SoftImplement("IForgeItem")
    public boolean onEntityItemUpdate(class_1799 stack, class_1542 entity) {
        if (!hasPattern(stack))
            NBTHelper.remove(stack, "BlockEntityTag");
        return false;
    }

    @Override
    public void method_7888(class_1799 pStack, class_1937 pLevel, class_1297 pEntity, int pSlotId, boolean pIsSelected) {
        if (!hasPattern(pStack))
            NBTHelper.remove(pStack, "BlockEntityTag");
    }

    @Override
    public @Nullable class_2487 readDatumTag(class_1799 stack) {
        var bet = NBTHelper.getCompound(stack, "BlockEntityTag");

        if (bet == null || !bet.contains(BlockEntitySlate.TAG_PATTERN, class_2520.field_33260)) {
            return null;
        }

        var patTag = bet.getCompound(BlockEntitySlate.TAG_PATTERN);
        if (patTag.isEmpty()) {
            return null;
        }
        var out = new class_2487();
        out.put(SpellDatum.TAG_PATTERN, patTag);
        return out;
    }

    @Override
    public boolean canWrite(class_1799 stack, SpellDatum<?> datum) {
        return datum == null || datum.getType() == DatumType.PATTERN;
    }

    @Override
    public void writeDatum(class_1799 stack, SpellDatum<?> datum) {
        if (this.canWrite(stack, datum)) {
            if (datum == null) {
                var beTag = NBTHelper.getOrCreateCompound(stack, "BlockEntityTag");
                beTag.remove(BlockEntitySlate.TAG_PATTERN);
                if (beTag.isEmpty())
                    NBTHelper.remove(stack, "BlockEntityTag");
            } else if (datum.getPayload() instanceof HexPattern pat) {
                var beTag = NBTHelper.getOrCreateCompound(stack, "BlockEntityTag");
                beTag.put(BlockEntitySlate.TAG_PATTERN, pat.serializeToNBT());
            }
        }
    }

    @Override
    public Optional<class_5632> method_32346(class_1799 stack) {
        var bet = NBTHelper.getCompound(stack, "BlockEntityTag");

        if (bet != null && bet.contains(BlockEntitySlate.TAG_PATTERN, class_2520.field_33260)) {
            var patTag = bet.getCompound(BlockEntitySlate.TAG_PATTERN);
            if (!patTag.isEmpty()) {
                var pattern = HexPattern.fromNBT(patTag);
                return Optional.of(new PatternTooltipGreeble(
                    pattern,
                    PatternTooltipGreeble.SLATE_BG));
            }
        }
        return Optional.empty();
    }
}
