package at.petrak.hexcasting.common.items;

import at.petrak.hexcasting.api.item.DataHolderItem;
import at.petrak.hexcasting.api.spell.DatumType;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.client.gui.PatternTooltipGreeble;
import at.petrak.hexcasting.common.entities.EntityWallScroll;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.Optional;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_5632;
import net.minecraft.class_5712;

import static at.petrak.hexcasting.api.HexAPI.modLoc;

/**
 * TAG_OP_ID and TAG_PATTERN: "Ancient Scroll of %s" (Great Spells)
 * <br>
 * TAG_PATTERN: "Scroll" (custom)
 * <br>
 * (none): "Empty Scroll"
 * <br>
 * TAG_OP_ID: invalid
 */
public class ItemScroll extends class_1792 implements DataHolderItem {
    public static final String TAG_OP_ID = "op_id";
    public static final String TAG_PATTERN = "pattern";
    public static final class_2960 ANCIENT_PREDICATE = modLoc("ancient");

    public ItemScroll(class_1793 pProperties) {
        super(pProperties);
    }

    @Override
    public @Nullable class_2487 readDatumTag(class_1799 stack) {
        class_2487 pattern = NBTHelper.getCompound(stack, TAG_PATTERN);
        if (pattern == null) {
            return null;
        }
        var out = new class_2487();
        out.put(SpellDatum.TAG_PATTERN, pattern);
        return out;
    }

    @Override
    public boolean canWrite(class_1799 stack, SpellDatum<?> datum) {
        return datum != null && datum.getType() == DatumType.PATTERN && !NBTHelper.hasCompound(stack, TAG_PATTERN);
    }

    @Override
    public void writeDatum(class_1799 stack, SpellDatum<?> datum) {
        if (this.canWrite(stack, datum) && datum.getPayload() instanceof HexPattern pat) {
            NBTHelper.putCompound(stack, TAG_PATTERN, pat.serializeToNBT());
        }
    }

    @Override
    public class_1269 method_7884(class_1838 ctx) {
        var posClicked = ctx.method_8037();
        var direction = ctx.method_8038();
        var posInFront = posClicked.relative(direction);
        class_1657 player = ctx.method_8036();
        class_1799 itemstack = ctx.method_8041();
        if (player != null && !this.mayPlace(player, direction, itemstack, posInFront)) {
            return class_1269.field_5814;
        }
        var level = ctx.method_8045();
        var scrollStack = itemstack.method_7972();
        scrollStack.setCount(1);
        var scrollEntity = new EntityWallScroll(level, posInFront, direction, scrollStack, false);

        // i guess
        var stackTag = itemstack.method_7969();
        if (stackTag != null) {
            class_1299.method_5881(level, player, scrollEntity, stackTag);
        }

        if (scrollEntity.survives()) {
            if (!level.isClientSide) {
                scrollEntity.playPlacementSound();
                level.gameEvent(player, class_5712.field_28738, posClicked);
                level.addFreshEntity(scrollEntity);
            }

            itemstack.method_7934(1);
            return class_1269.method_29236(level.isClientSide);
        } else {
            return class_1269.field_21466;
        }
    }

    protected boolean mayPlace(class_1657 pPlayer, class_2350 pDirection, class_1799 pHangingEntityStack, class_2338 pPos) {
        return !pDirection.method_10166().method_10178() && pPlayer.method_7343(pPos, pDirection, pHangingEntityStack);
    }

    @Override
    public class_2561 method_7864(class_1799 pStack) {
        var ancientId = NBTHelper.getString(pStack, TAG_OP_ID);
        if (ancientId != null) {
            return new class_2588("item.hexcasting.scroll.of",
                new class_2588("hexcasting.spell." + class_2960.method_12829(ancientId)));
        } else if (NBTHelper.hasCompound(pStack, TAG_PATTERN)) {
            return new class_2588("item.hexcasting.scroll");
        } else {
            return new class_2588("item.hexcasting.scroll.empty");
        }
    }

    // purposely no hover text

    @Override
    public Optional<class_5632> method_32346(class_1799 stack) {
        var compound = NBTHelper.getCompound(stack, ItemScroll.TAG_PATTERN);
        if (compound != null) {
            var pattern = HexPattern.fromNBT(compound);
            return Optional.of(new PatternTooltipGreeble(
                pattern,
                NBTHelper.hasString(stack,
                    ItemScroll.TAG_OP_ID) ? PatternTooltipGreeble.ANCIENT_BG : PatternTooltipGreeble.PRISTINE_BG));
        }

        return Optional.empty();
    }
}
