package at.petrak.hexcasting.common.items;

import at.petrak.hexcasting.annotations.SoftImplement;
import at.petrak.hexcasting.common.network.MsgUpdateComparatorVisualsAck;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.datafixers.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_239;
import net.minecraft.class_2741;
import net.minecraft.class_2969;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3965;
import net.minecraft.class_5151;

public class ItemLens extends class_1792 implements class_5151 {

    public ItemLens(class_1793 pProperties) {
        super(pProperties);
        class_2315.method_10009(this, new class_2969() {
            protected @NotNull
            class_1799 method_10135(@NotNull class_2342 world, @NotNull class_1799 stack) {
                this.method_27955(class_1738.method_7684(world, stack));
                return stack;
            }
        });
    }

    // In fabric impled with extension property?
    @Nullable
    @SoftImplement("forge")
    public class_1304 getEquipmentSlot(class_1799 stack) {
        return class_1304.field_6169;
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        class_1304 equipmentslot = class_1308.method_32326(itemstack);
        class_1799 stack = player.method_6118(equipmentslot);
        if (stack.method_7960()) {
            player.method_5673(equipmentslot, itemstack.method_7972());
            if (!world.method_8608()) {
                player.method_7259(class_3468.field_15372.method_14956(this));
            }

            itemstack.method_7939(0);
            return class_1271.method_29237(itemstack, world.method_8608());
        } else {
            return class_1271.method_22431(itemstack);
        }
    }

    @Override
    public void method_7888(class_1799 pStack, class_1937 pLevel, class_1297 pEntity, int pSlotId, boolean pIsSelected) {
        if (!pLevel.method_8608() && pEntity instanceof class_3222 player) {
            if (pStack == player.method_6118(class_1304.field_6169) ||
                pStack == player.method_6118(class_1304.field_6173) ||
                pStack == player.method_6118(class_1304.field_6171)) {
                sendComparatorDataToClient(player);
            }
        }
    }

    private static final Map<class_3222, Pair<class_2338, Integer>> comparatorDataMap = new WeakHashMap<>();

    private void sendComparatorDataToClient(class_3222 player) {
        double reachAttribute = player.method_5996(IXplatAbstractions.INSTANCE.getReachDistance()).method_6194();
        double distance = player.method_7337() ? reachAttribute : reachAttribute - 0.5;
        var hitResult = player.method_5745(distance, 0, false);
        if (hitResult.getType() == class_239.class_240.field_1332) {
            var pos = ((class_3965) hitResult).method_17777();
            var state = player.field_6002.method_8320(pos);
            if (state.is(class_2246.field_10377)) {
                syncComparatorValue(player, pos,
                    state.getDirectSignal(player.field_6002, pos, state.getValue(class_2741.field_12481)));
            } else if (state.hasAnalogOutputSignal()) {
                syncComparatorValue(player, pos, state.getAnalogOutputSignal(player.field_6002, pos));
            } else {
                syncComparatorValue(player, null, -1);
            }
        } else {
            syncComparatorValue(player, null, -1);
        }
    }

    private void syncComparatorValue(class_3222 player, class_2338 pos, int value) {
        var previous = comparatorDataMap.get(player);
        if (value == -1) {
            if (previous != null) {
                comparatorDataMap.remove(player);
                IXplatAbstractions.INSTANCE.sendPacketToPlayer(player, new MsgUpdateComparatorVisualsAck(null, -1));
            }
        } else if (previous == null || (!pos.equals(previous.getFirst()) || value != previous.getSecond())) {
            comparatorDataMap.put(player, new Pair<>(pos, value));
            IXplatAbstractions.INSTANCE.sendPacketToPlayer(player, new MsgUpdateComparatorVisualsAck(pos, value));
        }
    }

    @Nullable
    @Override
    public class_3414 method_31570() {
        return class_3417.field_26980;
    }

}
