package at.petrak.hexcasting.common.items;

import at.petrak.hexcasting.api.item.DataHolderItem;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.Widget;
import at.petrak.hexcasting.api.utils.NBTHelper;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

import static at.petrak.hexcasting.api.HexAPI.modLoc;

public class ItemFocus extends class_1792 implements DataHolderItem {
    public static final class_2960 DATATYPE_PRED = modLoc("datatype");
    public static final class_2960 SEALED_PRED = modLoc("sealed");

    public static final String TAG_DATA = "data";
    public static final String TAG_SEALED = "sealed";

    public ItemFocus(class_1793 pProperties) {
        super(pProperties);
    }

    @Override
    public @Nullable class_2487 readDatumTag(class_1799 stack) {
        return NBTHelper.getCompound(stack, TAG_DATA);
    }

    @Override
    public String method_7866(class_1799 stack) {
        return super.method_7866(stack) + (NBTHelper.getBoolean(stack, TAG_SEALED) ? ".sealed" : "");
    }

    @Override
    public @Nullable SpellDatum<?> emptyDatum(class_1799 stack) {
        return SpellDatum.make(Widget.NULL);
    }

    @Override
    public boolean canWrite(class_1799 stack, SpellDatum<?> datum) {
        return datum == null || !NBTHelper.getBoolean(stack, TAG_SEALED);
    }

    @Override
    public void writeDatum(class_1799 stack, SpellDatum<?> datum) {
        if (datum == null) {
            stack.method_7983(TAG_DATA);
            stack.method_7983(TAG_SEALED);
        } else if (!NBTHelper.getBoolean(stack, TAG_SEALED))
            NBTHelper.put(stack, TAG_DATA, datum.serializeToNBT());
    }

    @Override
    public void method_7851(class_1799 pStack, @Nullable class_1937 pLevel, List<class_2561> pTooltipComponents,
        class_1836 pIsAdvanced) {
        DataHolderItem.appendHoverText(this, pStack, pTooltipComponents, pIsAdvanced);
    }
}
