package at.petrak.hexcasting.common.items;

import at.petrak.hexcasting.api.item.DataHolderItem;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.lib.HexSounds;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;

public class ItemAbacus extends class_1792 implements DataHolderItem {
    public static final String TAG_VALUE = "value";

    public ItemAbacus(class_1793 pProperties) {
        super(pProperties);
    }

    @Override
    public @Nullable class_2487 readDatumTag(class_1799 stack) {
        var datum = SpellDatum.make(NBTHelper.getDouble(stack, TAG_VALUE));
        return datum.serializeToNBT();
    }

    @Override
    public boolean canWrite(class_1799 stack, SpellDatum<?> datum) {
        return false;
    }

    @Override
    public void writeDatum(class_1799 stack, SpellDatum<?> datum) {
        // nope
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        var stack = player.method_5998(hand);
        if (player.method_5715()) {
            double oldNum = NBTHelper.getDouble(stack, TAG_VALUE);
            stack.removeTagKey(TAG_VALUE);

            player.method_5783(HexSounds.ABACUS_SHAKE, 1f, 1f);

            var key = "hexcasting.tooltip.abacus.reset";
            if (oldNum == 69) {
                key += ".nice";
            }
            player.method_7353(new class_2588(key), true);

            return class_1271.method_29237(stack, world.field_9236);
        } else {
            return class_1271.method_22430(stack);
        }
    }

    @Override
    public void method_7851(class_1799 pStack, @Nullable class_1937 pLevel, List<class_2561> pTooltipComponents,
        class_1836 pIsAdvanced) {
        DataHolderItem.appendHoverText(this, pStack, pTooltipComponents, pIsAdvanced);
    }
}
