package at.petrak.hexcasting.common.entities;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2960;
import var;

import static at.petrak.hexcasting.api.HexAPI.modLoc;

public class HexEntities {
    public static void registerEntities(BiConsumer<class_1299<?>, class_2960> r) {
        for (var e : ENTITIES.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    private static final Map<class_2960, class_1299<?>> ENTITIES = new LinkedHashMap<>();

    public static final class_1299<EntityWallScroll> WALL_SCROLL = register("wall_scroll",
        class_1299.class_1300.<EntityWallScroll>method_5903(EntityWallScroll::new, class_1311.field_17715)
            .method_17687(0.5f, 0.5f).method_27299(10).method_27300(Integer.MAX_VALUE)
            .method_5905("wall_scroll"));

    private static <T extends class_1297> class_1299<T> register(String id, class_1299<T> type) {
        var old = ENTITIES.put(modLoc(id), type);
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + id);
        }
        return type;
    }
}
