package at.petrak.hexcasting.common.entities;

import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.client.RenderLib;
import at.petrak.hexcasting.common.items.ItemScroll;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.lib.HexSounds;
import at.petrak.hexcasting.common.network.MsgNewWallScrollAck;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1530;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class EntityWallScroll extends class_1530 {
    private static final class_2940<Boolean> SHOWS_STROKE_ORDER = class_2945.method_12791(
        EntityWallScroll.class,
        class_2943.field_13323);

    public class_1799 scroll;
    public HexPattern pattern;
    public boolean isAncient;
    // Client-side only!
    public List<class_241> zappyPoints;

    public EntityWallScroll(class_1299<? extends EntityWallScroll> type, class_1937 world) {
        super(type, world);
    }

    public EntityWallScroll(class_1937 world, class_2338 pos, class_2350 dir, class_1799 scroll, boolean showStrokeOrder) {
        super(HexEntities.WALL_SCROLL, world, pos);
        this.loadDataFromScrollItem(scroll);
        this.method_6892(dir);
        this.setShowsStrokeOrder(showStrokeOrder);
    }

    private void loadDataFromScrollItem(class_1799 scroll) {
        this.scroll = scroll;

        class_2487 patternTag = NBTHelper.getCompound(scroll, ItemScroll.TAG_PATTERN);
        if (patternTag != null) {
            this.pattern = HexPattern.fromNBT(patternTag);
            if (this.field_6002.field_9236) {
                var pair = RenderLib.getCenteredPattern(pattern, 128, 128, 16f);
                var dots = pair.getSecond();
                this.zappyPoints = RenderLib.makeZappy(dots, 10f, 0.8f, 0f, 0f);
            }

            this.isAncient = NBTHelper.hasString(scroll, ItemScroll.TAG_OP_ID);
        } else {
            this.pattern = null;
            this.zappyPoints = null;
            this.isAncient = false;
        }
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SHOWS_STROKE_ORDER, false);
    }

    public boolean getShowsStrokeOrder() {
        return this.field_6011.method_12789(SHOWS_STROKE_ORDER);
    }

    public void setShowsStrokeOrder(boolean b) {
        this.field_6011.method_12778(SHOWS_STROKE_ORDER, b);
    }

    @Override
    public int method_6897() {
        return 48;
    }

    @Override
    public int method_6891() {
        return 48;
    }

    @Override
    public void method_6889(@Nullable class_1297 pBrokenEntity) {
        if (this.field_6002.method_8450().method_8355(class_1928.field_19393)) {
            this.method_5783(class_3417.field_14809, 1.0F, 1.0F);
            if (pBrokenEntity instanceof class_1657 player) {
                if (player.method_31549().field_7477) {
                    return;
                }
            }

            this.method_5775(this.scroll);
        }
    }

    @Override
    public class_1269 method_5664(class_1657 pPlayer, class_243 pVec, class_1268 pHand) {
        var handStack = pPlayer.method_5998(pHand);
        if (handStack.is(HexItems.AMETHYST_DUST) && !this.getShowsStrokeOrder()) {
            if (!pPlayer.method_31549().field_7477) {
                handStack.shrink(1);
            }
            this.setShowsStrokeOrder(true);

            pPlayer.field_6002.method_8449(pPlayer, this, HexSounds.SCROLL_DUST, class_3419.field_15248, 1f, 1f);
            return class_1269.field_5812;
        }
        return super.method_5664(pPlayer, pVec, pHand);
    }

    @Override
    public void method_6894() {
        this.method_5783(class_3417.field_14875, 1.0F, 1.0F);
    }

    @Override
    public class_2596<?> method_18002() {
        return IXplatAbstractions.INSTANCE.toVanillaClientboundPacket(
            new MsgNewWallScrollAck(new class_2604(this),
                field_7100, field_7099, scroll, getShowsStrokeOrder()));
    }

    public void readSpawnData(class_2338 pos, class_2350 dir, class_1799 scrollItem,
        boolean showsStrokeOrder) {
        this.field_7100 = pos;
        this.method_6892(dir);
        this.loadDataFromScrollItem(scrollItem);
        this.setShowsStrokeOrder(showsStrokeOrder);
    }

    @Override
    public void method_5652(class_2487 tag) {
        tag.method_10567("direction", (byte) this.field_7099.ordinal());
        tag.method_10566("scroll", HexUtils.serializeToNBT(this.scroll));
        tag.method_10556("showsStrokeOrder", this.getShowsStrokeOrder());
        super.method_5652(tag);
    }

    @Override
    public void method_5749(class_2487 tag) {
        this.field_7099 = class_2350.values()[tag.method_10571("direction")];
        var scroll = class_1799.method_7915(tag.method_10562("scroll"));
        this.setShowsStrokeOrder(tag.method_10577("showsStrokeOrder"));

        super.method_5749(tag);
        this.method_6892(this.field_7099);
        this.loadDataFromScrollItem(scroll);
    }

    @Override
    public void method_5808(double pX, double pY, double pZ, float pYaw, float pPitch) {
        this.method_5814(pX, pY, pZ);
    }

    @Override
    public void method_5759(double pX, double pY, double pZ, float pYaw, float pPitch, int pPosRotationIncrements,
        boolean pTeleport) {
        class_2338 blockpos = this.field_7100.method_10080(pX - this.method_23317(), pY - this.method_23318(), pZ - this.method_23321());
        this.method_5814(blockpos.method_10263(), blockpos.method_10264(), blockpos.method_10260());
    }

    @Nullable
    @Override
    public class_1799 method_31480() {
        return this.scroll.method_7972();
    }
}
